Summary: Exploring Conway's Game of Life and other cellular automata
Name: golly
Version: 2.7
Release: alt1

License: GPL
Url: http://golly.sourceforge.net/
Source: %name-%version-src.tar.gz
Source1: %name.sh
Source2: %name.desktop
Group: Education

# TODO: split binary and data
%add_python_req_skip glife golly

Patch: %name-2.1-opensave-alt.patch
Patch1: %name-2.5-perl_syntax-alt.patch

# Automatically added by buildreq on Tue Sep 28 2010
BuildRequires: ImageMagick-tools gcc-c++ libwxGTK-devel perl-devel python-devel zlib-devel

BuildRequires: perl-Math-BigInt

%description
Welcome to Golly, a sophisticated tool for exploring Conway's
Game of Life and other cellular automata.

- Unbounded universe (limited only by memory).
- Fast, memory-efficient conventional algorithm.
- Use hashing to see large patterns evolve at huge time scales.
- Responsive even while generating or garbage collecting.
- Reads RLE, Life 1.05/1.06, dblife, and macrocell formats.
- Can also read common graphic formats: BMP, PNG, GIF, TIFF.
- Includes a state-of-the-art pattern collection.
- Supports other Life-like rules and Wolfram's 1D rules.
- Fast loading of large patterns.
- Paste in patterns from the clipboard.
- Unlimited undo/redo.
- Unbounded zooming out for astronomical patterns.
- Auto fit option keeps a generating pattern within view.
- Full screen option (no menu/status/tool/scroll bars).
- Supports multiple layers, including cloned layers.
- HTML-based help with integrated Life Lexicon.
- Scriptable via Perl or Python.
- User-configurable keyboard shortcuts.
- Free, open source and cross-platform (Windows, Mac, Linux).
- We also provide bgolly, a GUI-less version.

%prep
%setup -n %name-%version-src
#patch -p1
%patch1 -p1
sed -i 's/NEEDED +libperl\[/NEEDED +libperl[-/' gui-wx/configure/configure

%build
cd gui-wx
sed -i '/#include <EXTERN.h>/a\
#define PERL_GLOBAL_STRUCT
' wxperl.cpp
cd configure
%configure --with-perl-shlib=%_libdir/perl5/CORE/libperl.so

%make_build

cd ..
for N in 16 32 48; do convert icons/appicon$N.ico $N.png; done

%install
cd gui-wx/configure
%makeinstall
cd ..
for N in 16 32 48; do
  install -D $N.png %buildroot%_iconsdir/hicolor/${N}x$N/apps/%name.png
done

install -D %SOURCE2 %buildroot%_desktopdir/%name.desktop

%files
%exclude %_datadir/doc/%name
%doc docs/*
%_bindir/*
%_datadir/%name
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_desktopdir/*

%changelog
