%def_with pic
%define Name GParted

Name: gparted
Version: 0.29.0
Release: alt0.M80P.2

Summary: %Name Partition Editor
Summary(ru_RU.UTF-8): Редактор разделов %Name
Summary(uk_UA.UTF-8): Редактор розділів %Name
License: %gpl2plus
Group: System/Configuration/Hardware
URL: http://%name.sourceforge.net/

#Source: %name-%version.tar
Source: http://prdownloads.sourceforge.net/%name/%name-%version.tar.gz
Source1: %name-pam
Source2: %name-security
Source3: ru.po

Patch1: %name-0.29.0-alt-dmraid.patch

AutoReq: yes, noshell

Requires: consolehelper
Requires: hdparm
# for raid support
Requires: mdadm dmraid dmsetup lvm2 cryptsetup
#Requires: ntfs-3g btrfs-progs >= 4.1
# for UDF filesystems support
#Requires: udftools

BuildRequires(pre): rpm-build-licenses
BuildRequires: libparted-devel >= 3.2
BuildRequires: libgtkmm2-devel >= 2.22.0
BuildRequires: gcc-c++ libprogsreiserfs-devel libuuid-devel intltool
BuildRequires: perl-XML-Parser gnome-doc-utils gnome-common librarian

%description
%Name stands for %Name Partition Editor. It uses libparted to detect
and manipulate devices and partitiontables while several (optional)
filesystemtools provide support for filesystems not included in
libparted. These optional packages will be detected at runtime and
don't require a rebuild of %Name.
%Name is written in C++ and uses gtkmm as Graphical Toolkit. The
general approach is to keep the GUI as simple as possible.

%description -l ru_RU.UTF-8
%Name - %Name Partition Editor. Он использует libparted для
обнаружения и манипуляций с устройствами и таблицами разделов, а также
некоторые (необязательные) инструменты (не включенные в libparted),
обеспечивающие поддержку файловых систем. Эти необязательные пакеты
обнаруживаются во время выполнения и не требуют пересборки %Name.
%Name написан на C++ с использованием gtkmm в качестве графического
инструментария. Главная задача - оставить GUI максимально простым.

%description -l uk_UA.UTF-8
%Name - %Name Partition Editor. Він використовує libparted для
виявлення та маніпуляцій з пристроями і таблицями разділів, а також
деякі (необов'язкові) інструменти (не включені в libparted), які
забезпечують підтримку файлових систем. Ці необов'язкові пакети
виявляються під час виконання і не потребують перебудови %Name.
%Name написано на C++ з використанням gtkmm в якості графічного
інструментарію. Головне завдання - залишити GUI максимально простим.


%prep
%setup
%patch1 -p0
cp -f %SOURCE3 po/

%build
#NOCONFIGURE=1 ./autogen.sh
%configure %{subst_with pic} --bindir=%_sbindir \
	--enable-libparted-dmraid \
	--enable-online-resize
%make_build
bzip2 --best --keep --force ChangeLog

%install
%makeinstall_std

# usermode
install -pD -m640 %SOURCE1 %buildroot%_sysconfdir/pam.d/%name
install -pD -m640 %SOURCE2 %buildroot%_sysconfdir/security/console.apps/%name
install -d -m 0755 %buildroot%_bindir
ln -s %_bindir/consolehelper %buildroot%_bindir/%name
sed -i 's|%_sbindir|%_bindir|' %buildroot%_desktopdir/%name.desktop

%find_lang --with-gnome %name

%files -f %name.lang
%doc AUTHORS ChangeLog.* README
%_sbindir/*
%_bindir/*
%_man8dir/*
%_sysconfdir/pam.d/*
%_sysconfdir/security/console.apps/*
%_iconsdir/hicolor/*/apps/*
%_desktopdir/*
%_datadir/appdata/%name.appdata.xml

%changelog
