
%define rname gpgme

%define gpgme_pthread_sover 11
%define libgpgme_pthread libgpgme-pthread%gpgme_pthread_sover

%define min_gnupg_version 1.9.6
%define gpg_bin_path %_bindir/gpg2
%define gpgsm_bin_path %_bindir/gpgsm

%add_python3_req_skip _gpgme
%add_python_req_skip _gpgme

Name: gpgme17
Version: 1.7.1
Release: alt3.M80P.1

Summary: GnuPG Made Easy is a library designed to make access to GnuPG easier for applications
License: LGPLv2.1+
Group: System/Libraries
Url: http://www.gnupg.org/related_software/gpgme/index.html

Conflicts: libgpgme-devel < 1.7
Requires: %gpg_bin_path

# ftp://ftp.gnupg.org/gcrypt/gpgme/gpgme-%version.tar.bz2
Source: %rname-%version.tar

Patch1: gpgme-1.4.3-alt-version-script.patch
Patch2: gpgme-1.3.0-alt-gpgme-config-assuan.patch
Patch3: gpgme-1.3.0-alt-tests.patch
Patch4: gpgme-1.3.2-rh-alt-linkage.patch


%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

BuildRequires(pre): rpm-build-ubt
BuildRequires(pre): python-devel python3-devel
BuildRequires: /proc gcc-c++ gnupg2 libgpg-error-devel libpth-devel libstdc++-devel libassuan-devel >= 2.0
BuildRequires: texinfo
BuildRequires: qt5-base-devel swig
BuildRequires: libgpgme-devel

%package common
Summary: %name common package
Group: System/Configuration/Other
%description common
%name common package

%package -n %libgpgme_pthread
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
Requires: %gpg_bin_path
%description -n %libgpgme_pthread
%name library

%package -n python3-module-pyme
Summary: Python GpgME pindings
Group: Development/Python
%description -n python3-module-pyme
Python GpgME pindings

%package -n python-module-pyme
Summary: Python GpgME pindings
Group: Development/Python
%description -n python-module-pyme
Python GpgME pindings

%description
GnuPG Made Easy (GPGME) is a C language library that allows to add
support for cryptography to a program.  It is designed to make access
to public key crypto engines like GnuPG or GpgSM easier for
applications.  GPGME provides a high-level crypto API for encryption,
decryption, signing, signature verification and key management.

%prep
%setup -qn %rname-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
#%patch4 -p1

rm doc/*.info* m4/{libtool,lt}*.m4

%autoreconf

%build
mkdir -p tmp_bin
ln -sf %_bindir/gpg2 tmp_bin/gpg
export PATH=$PWD/tmp_bin:$PATH

%{?!_enable_static:export lt_cv_prog_cc_static_works=no}
# --enable-maintainer-mode is required to generate the info file
# when building from CVS snapshot
%configure \
	%{?cvsdate: --enable-maintainer-mode } \
	%{subst_enable static} \
	--with-gpg=%gpg_bin_path \
	--with-gpgsm=%gpgsm_bin_path

%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std

# remove unsuitable files
rm -rf %buildroot/%_includedir
rm -rf %buildroot/%_datadir
rm -rf %buildroot/%_bindir
rm -rf %buildroot/%_libdir/cmake
rm -rf %buildroot/%_libdir/lib*.so
rm -rf %buildroot/%_libdir/lib{q,}gpgme{pp,}.so.*

#check
#export PATH=$PWD/tmp_bin:$PATH
#%make_build -k check

%files common
%doc AUTHORS NEWS README THANKS

%files -n python3-module-pyme
%python3_sitelibdir/pyme*

%files -n python-module-pyme
%python_sitelibdir/pyme*

%files -n %libgpgme_pthread
%_libdir/libgpgme-pthread.so.%gpgme_pthread_sover
%_libdir/libgpgme-pthread.so.%gpgme_pthread_sover.*

%changelog
