%define ver_major 0.3
%define api_ver %ver_major
%def_enable gtk_doc

Name: grilo
Version: %ver_major.4
Release: alt0.M80P.1

Summary: Content discovery framework
Group: Sound
License: LGPLv2+
Url: https://wiki.gnome.org/Projects/Grilo

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildRequires: gnome-common intltool >= 0.40.0
BuildRequires: libgio-devel >= 2.44
BuildRequires: libxml2-devel
BuildRequires: libgtk+3-devel >= 3.0
BuildRequires: libsoup-devel >= 2.41.3 libsoup-gir-devel
BuildRequires: liboauth-devel
BuildRequires: vala-tools >= 0.27 libvala-devel
BuildRequires: gtk-doc >= 1.10
BuildRequires: gobject-introspection-devel >= 0.9.0
BuildRequires: libtotem-pl-parser-devel >= 3.4.1
BuildRequires: gstreamer1.0-devel


%description
Grilo is a framework that provides access to different sources of
multimedia content, using a pluggable system.
This package contains the core library and elements.

%package -n lib%name
Summary: Libraries files for Grilo framework
Group: System/Libraries

%description -n lib%name
Grilo is a framework that provides access to different sources of
multimedia content, using a pluggable system.
This package contains the core library.

%package -n lib%name-devel
Summary: Development files for Grilo framework
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-devel
Grilo is a framework that provides access to different sources of
multimedia content, using a pluggable system.
This package contains the core library and elements, as well as
general and API documentation.

%package devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
Conflicts: lib%name < %version-%release
BuildArch: noarch

%description devel-doc
This package provides development documentation for %name.

%package -n lib%name-gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the %name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the %name library

%package tools
Summary: Tools for the %name library
Group: Sound
Requires: lib%name = %version-%release

%description tools
Tools for the %name library

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup

%build
%autoreconf
%configure \
	--disable-static	\
	--enable-vala		\
	--enable-gtk-doc	\
	--enable-introspection	\
	--enable-grl-net	\
	--enable-grl-pls	\
	--disable-tests

%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_libdir/grilo-%ver_major %buildroot%_datadir/grilo-%ver_major/plugins

%find_lang %name

# Remove files that will not be packaged
rm -f %buildroot%_bindir/grilo-simple-playlist

%check
# grilo-plugins should be installed for check
#%make check

%files tools
%doc AUTHORS COPYING NEWS README TODO
%_bindir/grl-inspect-%api_ver
%_bindir/grl-launch-%api_ver
%_bindir/grilo-test-ui-%api_ver
%_man1dir/*

%files -n lib%name -f %name.lang
%_libdir/*.so.*
%dir %_libdir/grilo-%ver_major
%dir %_datadir/grilo-%ver_major/plugins

%files -n lib%name-devel
%_includedir/%name-%api_ver/
%_libdir/*.so
%_pkgconfigdir/*-%api_ver.pc
%_vapidir/*

%files -n lib%name-gir
%_typelibdir/Grl-%api_ver.typelib
%_typelibdir/GrlNet-%api_ver.typelib
%_typelibdir/GrlPls-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Grl-%api_ver.gir
%_girdir/GrlNet-%api_ver.gir
%_girdir/GrlPls-%api_ver.gir

%if_enabled gtk_doc
%files devel-doc
%_gtk_docdir/%name/
%endif

%changelog
