%def_disable snapshot

%define ver_major 0.3

%def_disable lua_factory

Name: grilo-plugins
Version: %ver_major.5
Release: alt0.M80P.1

Summary: Plugins for the Grilo framework
Group: Sound
License: LGPLv2+
Url: https://wiki.gnome.org/Projects/Grilo

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: grilo-tools
Requires: tracker

BuildRequires: gnome-common intltool >= 0.40.0 gperf
BuildRequires: gtk-doc yelp-tools
BuildRequires: libgio-devel >= 2.36
BuildRequires: libgrilo-devel >= %ver_major.4
BuildRequires: libxml2-devel
BuildRequires: libgupnp-devel >= 0.13
BuildRequires: libgupnp-av-devel >= 0.5
BuildRequires: libgssdp-devel
BuildRequires: libsqlite3-devel
BuildRequires: libgdata-devel >= 0.9.1
BuildRequires: libgom-devel >= 0.3.2
BuildRequires: libsoup-devel
BuildRequires: libgcrypt-devel
BuildRequires: libgmime3.0-devel
BuildRequires: tracker-devel
BuildRequires: liboauth-devel
BuildRequires: libgnome-online-accounts-devel >= 3.18.0
BuildRequires: libtotem-pl-parser-devel >= 3.4.1
BuildRequires: libdmapsharing-devel >= 2.9.12
BuildRequires: libjson-glib-devel
BuildRequires: libavahi-gobject-devel libavahi-glib-devel libavahi-devel
BuildRequires: libmediaart2.0-devel
BuildRequires: librest-devel
BuildRequires: libarchive-devel
%{?_enable_lua_factory:BuildRequires: lua-devel >= 5.3}


%description
Grilo is a framework that provides access to different sources of
multimedia content, using a pluggable system.
This package contains plugins to get information from theses sources:
- Apple Trailers
- Bookmarks
- Filesystem
- Flickr
- Gravatar
- Jamendo
- Last.fm (for album arts)
- Local metadata (album arts and thumbnails)
- Metadata Store
- Podcasts
- Shoutcast
- Tracker
- UPnP
- Vimeo
- Youtube

%prep
%setup

%build
%autoreconf
%configure \
	--disable-static \
	%{?_enable_lua_factory:--enable-lua-factory}
%make_build

%install
%makeinstall_std

# Remove files that will not be packaged
rm -f %buildroot%_libdir/grilo-%ver_major/*.la

%find_lang --with-gnome %name

%files -f %name.lang
%doc AUTHORS COPYING NEWS README
%_libdir/grilo-%ver_major/*.so*
%if_enabled lua_factory
%dir %_datadir/%name/
%_datadir/%name/grl-lua-factory/
%endif

%changelog
