Name: groff
Version: 1.22.3
Release: alt1

Summary: A document formatting system
License: GPL
Group: Text tools
Url: ftp://ftp.gnu.org/gnu/%name
Packager: Alexey Gladkov <legion@altlinux.ru>

Source: %url/%name-%version.tar.gz
Source1: mandoc.local

Patch1: %name-1.19-alt-new_fonts.patch
Patch2: %name-1.19.1-alt-texinfo.patch
Patch3: %name-1.19.1-alt-use_system_getopt.patch
Patch6: %name-1.19.1-alt-tty-old_drawing_scheme.patch
Patch8: %name-1.19.1-rh-nohtml.patch
Patch9: %name-1.19.3-alt-nroff.patch
Patch10: %name-1.20.1-alt-perl.patch
Patch11: %name-1.19.3-fix-unicode-tmac.patch
Patch12: %name-1.22.3-add-T8bit.patch
Patch13: %name-1.20.1-replace-virmf.patch

PreReq: %name-base = %version-%release
Requires: %name-dvi = %version-%release
Requires: %name-lbp = %version-%release
Requires: %name-lj4 = %version-%release
Requires: %name-ps = %version-%release
Requires: %name-x11 = %version-%release
Requires: %name-extra = %version-%release

BuildRequires: fonts-type1-urw gcc-c++ ghostscript-module-X groff-base imake
BuildRequires: libXaw-devel netpbm psutils tcsh xorg-cf-files makeinfo
BuildRequires: perl-Math-Complex perl-IO-Compress

%package base
Summary: Parts of the %name formatting system that is required for viewing manpages
Group: Text tools
Provides: %name-tools, %name-for-man
Obsoletes: %name-tools, %name-for-man
Conflicts: %name < %version-%release
PreReq: coreutils

%package dvi
Summary: TeX dvi format driver for %name
Group: Text tools
Requires: %name-base = %version-%release

%package lbp
Summary: Canon CAPSL and VDM formats driver for %name
Group: Text tools
Requires: %name-base = %version-%release

%package lj4
Summary: HP Laserjet 4 family formats driver for %name
Group: Text tools
Requires: %name-base = %version-%release

%package pdf
Summary: PDF post processor for %name
Group: Text tools
Requires: %name-base = %version-%release

%package ps
Summary: PostScript driver for %name
Group: Text tools
Requires: %name-base = %version-%release

%package x11
Summary: An X previewer for %name text processor output
Group: Text tools
Provides: %name-gxditview = %version-%release
Obsoletes: %name-gxditview, gxditview
Requires: %name-base = %version-%release

%package extra
Summary: Additional %name components
Group: Text tools
Requires: %name-base = %version-%release

%description
Groff is a document formatting system.  Groff takes standard text and
formatting commands as input and produces formatted output.  The
created documents can be shown on a display or printed on a printer.
Groff's formatting commands allow you to specify font type and size, bold
type, italic type, the number and size of columns on a page, and more.

%description base
A stripped-down %name package containing the components required
to view man pages in ASCII, Latin-1 and UTF-8.

For a full %name installation, install %name package.

%description dvi
This package contains grodvi - driver for %name that produces TeX dvi format,
and corresponding files.

%description lbp
This package contains grolbp - driver for %name that produces output in
CAPSL and VDM format suitable for Canon LBP-4 and LBP-8 printers,
and corresponding files.

%description lj4
This package contains grolj4 - driver for %name that produces PCL5 format output
suitable for HP Laserjet 4 family printers, and corresponding files.

%description pdf
This package contains gropdf - PDF post processor for %name,
and corresponding files.

%description ps
This package contains grops - driver for %name that produces PostScript format,
and corresponding files.

%description x11
This package contains gxditview - program that displays the %name text
processor's output on an X Window System display, and corresponding files.

%description extra
This package contains additional %name components.

%prep
%setup -q

%patch1 -p1
#patch2 -p1
%patch3 -p1
%patch6 -p1
#patch8 -p1
%patch9 -p1
#patch10 -p2
%patch11 -p1
%patch12 -p1
%patch13 -p1

# Purge self-contained getopt.
rm -f src/include/getopt.h src/libs/lib%name/getopt*

%build
# Force parser regeneration.
find -type f -name \*.y |while read f; do
	rm -fv ${f%%.y}.cc
done

# Precache parameters.
export YACC='bison -y' PAGE=A4

%configure \
	--disable-rpath \
	 --with-appresdir=%_x11appconfdir \
	 #

# Ensure mkstemp is found.
grep -qs '^#define HAVE_MKSTEMP 1' src/include/config.h

%make_build -j1

%install
mkdir -p -- $RPM_BUILD_ROOT%prefix
%make_install install \
	DESTDIR="$RPM_BUILD_ROOT" \
	#

# Add ALT specific (deb-based).
cat %SOURCE1 >>$RPM_BUILD_ROOT%_datadir/%name/site-tmac/man.local
cat %SOURCE1 >>$RPM_BUILD_ROOT%_datadir/%name/site-tmac/mdoc.local

mkdir -p $RPM_BUILD_ROOT%_sysconfdir/buildreqs/files/ignore.d
cat >$RPM_BUILD_ROOT%_sysconfdir/buildreqs/files/ignore.d/%name <<EOF
^%_datadir/%name(/%version(/font)\?)\?\$
EOF

# Relocate config files.
mv $RPM_BUILD_ROOT%_datadir/%name/site-tmac $RPM_BUILD_ROOT%_sysconfdir/%name
ln -s -- %_sysconfdir/%name $RPM_BUILD_ROOT%_datadir/%name/site-tmac

# Required for PATCH12
ln -s -- devutf8 "$RPM_BUILD_ROOT%_datadir/%name/%version/font/dev8bit"

# <BEGIN BLACK MAGIC
for p in s m mse; do
	ln -s -- "$p.tmac" "$RPM_BUILD_ROOT%_datadir/%name/%version/tmac/g$p.tmac"
done

for f in $RPM_BUILD_ROOT{%_bindir,%_mandir/man*}/*; do
	n="${f##*/}"
	if [ -n "${n##*2*}" -a -n "${n##*-*}" -a -n "${n%%%%g*}" ]; then
		d="${f%%/*}/g$n"
		if [ ! -e "$d" ]; then
			ln -s -- "$n" "$d"
		fi
	fi
done
# END BLACK MAGIC>

# Cleanup
rm -rf \
	$RPM_BUILD_ROOT%_bindir/glilypond \
	$RPM_BUILD_ROOT%_libdir/%name/glilypond \
	$RPM_BUILD_ROOT%_datadir/%name/%version/oldfont \
	#

# Prepare file lists.
find $RPM_BUILD_ROOT%_bindir $RPM_BUILD_ROOT%_mandir -type f -o -type l |
	sed -e "s|$RPM_BUILD_ROOT||g" |
	grep -E '/g?(eqn|groff|grog|grotty|neqn|nroff|pic|preconv|refer|soelim|tbl|troff)(\.|$)' |
	sed 's|\(/man/.*\.[0-9]\)\(.*\)|\1*|g' >%name-base.files

find $RPM_BUILD_ROOT%_bindir $RPM_BUILD_ROOT%_mandir -type f -o -type l |
	sed -e "s|$RPM_BUILD_ROOT||g" |
	grep -E '/g?(xditview|xtotroff)(\.|$)' |
	sed 's|\(/man/.*\.[0-9]\)\(.*\)|\1*|g'>%name-x11.files

find $RPM_BUILD_ROOT%_bindir $RPM_BUILD_ROOT%_mandir/ -type f -o -type l |
	sed -e "s|$RPM_BUILD_ROOT||g" |
	grep -Ev '/g?(eqn|groff|grog|grodvi|grolbp|grolj4|grotty|gropdf|grops|neqn|nroff|pic|preconv|refer|soelim|tbl|troff|xditview|xtotroff)(\.|$)' |
	sed 's|\(/man/.*\.[0-9]\)\(.*\)|\1*|g' >%name-extra.files

# Prepare docs.
install -p -m644 BUG-REPORT ChangeLog MORE.STUFF NEWS PROBLEMS PROJECTS README TODO \
	$RPM_BUILD_ROOT%_docdir/%name-%version/
rm -f $RPM_BUILD_ROOT%_docdir/%name-%version/*.m?
bzip2 -9 $RPM_BUILD_ROOT%_docdir/%name-%version/*.ps 

mkdir -p $RPM_BUILD_ROOT%_docdir/%name-%version/X11
install -p -m644 src/devices/xditview/{ChangeLog,README,TODO} \
	$RPM_BUILD_ROOT%_docdir/%name-%version/X11/

%define r_dir %_sysconfdir/%name
%define r_link %_datadir/%name/site-tmac

%pre base
f=%r_link
if [ -d "$f" -a ! -L "$f" ]; then
	rm -rf "$f"
	/bin/touch "$f.RPMLOCK"
fi

%post base
d=%r_dir
f=%r_link
if [ -f "$f.RPMLOCK" -a -d "$d" -a ! -d "$d.RPMSAVE" ]; then
	mv "$d" "$d.RPMSAVE"
	rm -f "$f.RPMLOCK"
fi

%triggerpostun base -- %name-base < 0:1.18.1-alt2, %name < 0:0:1.18.1-alt1
d=%r_dir
if [ -d "$d.RPMSAVE" -a ! -d "$d" ]; then
	mv "$d.RPMSAVE" "$d"
fi

%files

%files base -f %name-base.files
%config %_sysconfdir/buildreqs/files/ignore.d/%name
%config %_sysconfdir/%name
%_libdir/%name
%dir %_datadir/%name
%_datadir/%name/site-tmac
%dir %_datadir/%name/%version
%_datadir/%name/%version/eign
%_datadir/%name/%version/tmac
%dir %_datadir/%name/%version/font
%_datadir/%name/%version/font/devascii
%_datadir/%name/%version/font/devlatin1
%_datadir/%name/%version/font/devutf8
%_datadir/%name/%version/font/dev8bit
%dir %_docdir/%name-%version
%_docdir/%name-%version/[ABD-WYZ]*
%exclude %_libdir/%name/groffer

%files dvi
%_bindir/grodvi
%_man1dir/grodvi.*
%dir %_datadir/%name
%dir %_datadir/%name/%version
%dir %_datadir/%name/%version/font
%_datadir/%name/%version/font/devdvi

%files lbp
%_bindir/grolbp
%_man1dir/grolbp.*
%dir %_datadir/%name
%dir %_datadir/%name/%version
%dir %_datadir/%name/%version/font
%_datadir/%name/%version/font/devlbp

%files lj4
%_bindir/grolj4
%_man1dir/grolj4.*
%dir %_datadir/%name
%dir %_datadir/%name/%version
%dir %_datadir/%name/%version/font
%_datadir/%name/%version/font/devlj4

%files pdf
%_bindir/gropdf
%_man1dir/gropdf.*
%dir %_datadir/%name
%dir %_datadir/%name/%version
%dir %_datadir/%name/%version/font
%_datadir/%name/%version/font/devpdf

%files ps
%_bindir/grops
%_man1dir/grops.*
%dir %_datadir/%name
%dir %_datadir/%name/%version
%dir %_datadir/%name/%version/font
%_datadir/%name/%version/font/devps

%files x11 -f %name-x11.files
%config %_x11appconfdir/GXditview*
%dir %_datadir/%name
%dir %_datadir/%name/%version
%dir %_datadir/%name/%version/font
%_datadir/%name/%version/font/devX*
%dir %_docdir/%name-%version
%_docdir/%name-%version/X11

%files extra -f %name-extra.files
%_infodir/*.info*
%_libdir/%name/groffer
%dir %_datadir/%name
%dir %_datadir/%name/%version
%dir %_datadir/%name/%version/font
%_datadir/%name/%version/font/devhtml
%_datadir/%name/%version/pic
%dir %_docdir/%name-%version
%_docdir/%name-%version/ChangeLog*
%_docdir/%name-%version/[a-z]*

%changelog
