Name: grub
Version: 2.02
Release: alt14

Summary: GRand Unified Bootloader
License: GPL
Group: System/Kernel and hardware

Url: http://www.gnu.org/software/grub

Source0: %name-%version.tar
Source1: grub2-sysconfig

Source3: 39_memtest
Source4: grub.filetrigger

Source5: grub-extras-%version.tar

Source6: grub-autoupdate

Source8: update-grub
Source9: update-grub.8

Source10: grub-efi-autoupdate
Source11: embedded_grub.cfg

Patch0: grub-2.02-os-alt.patch
Patch1: grub-2.00-sysconfig-path-alt.patch
Patch2: grub-2.02-altlinux-theme.patch
Patch3: grub-2.00-debian-uefi-os-prober.patch
Patch4: grub-2.02-os-alt-xen.patch
Patch5: grub-2.02-debian-disable_floppies.patch
Patch6: grub-2.02-add-fw_path-variable.patch
Patch7: grub-2.02-efibootmgr-check.patch
Patch8: grub-2.02-debian-install_signed.patch
Patch9: grub-2.00-fedora-unrestricted.patch
Patch10: grub2-stfu.patch
Patch11: grub-2.02-shift-interrupt-timeout.patch
Patch12: grub-2.02-ubuntu-efi-setup.patch
Patch13: grub-2.02-check_writes-alt.patch
Patch14: grub-2.02-alt-luks-use-uuid.patch
Patch15: grub-2.02-alt-fedora-linuxefi.patch
Patch16: grub-2.02-suse-fix-build-with-gcc8.patch
Patch17: grub-2.02-fix-binutils-break-grub-efi-build.patch
Patch18: grub-2.02-upstream-default-ptimer.patch

BuildRequires: flex fonts-bitmap-misc fonts-ttf-dejavu libfreetype-devel python-modules ruby autogen
BuildRequires: liblzma-devel help2man zlib-devel
BuildRequires: libdevmapper-devel
BuildRequires: texinfo
BuildRequires: pesign >= 0.109-alt4
BuildRequires: rpm-macros-uefi

# fonts: choose one

## dejavu
#BuildRequires: fonts-ttf-dejavu
#define font /usr/share/fonts/ttf/dejavu/DejaVuSansMono.ttf

## terminus
#BuildRequires: fonts-bitmap-terminus
#define font /usr/share/fonts/bitmap/terminus/ter-x16n.pcf.gz

## univga
BuildRequires: fonts-bitmap-univga
%define font /usr/share/fonts/bitmap/univga/u_vga16_9.pcf.gz

## see also fonts-bitmap-ucs-miscfixed; efont-unicode doesn't fit

Requires: gettext

# NB: not a fashion but the critical need to fit into 62 sectors
%define _optlevel s

%ifarch %ix86
%global grubefiarch i386-efi
%endif
%ifarch x86_64
%global grubefiarch x86_64-efi
%endif
%ifarch aarch64
%global grubefiarch arm64-efi
%endif

%package common
Summary: GRand Unified Bootloader (common part)
Group: System/Kernel and hardware
Provides: grub2-common = %EVR
Obsoletes: grub2-common < %EVR

%package pc
Summary: GRand Unified Bootloader (PC BIOS variant)
Group: System/Kernel and hardware
Requires: %name-common = %version-%release
%ifarch %ix86 x86_64
Provides: grub2 = %EVR
Provides: grub = %EVR
%endif
Provides: grub2-pc = %EVR
Obsoletes: grub2-pc < %EVR

%package efi
Summary: GRand Unified Bootloader (UEFI variant)
Group: System/Kernel and hardware
Requires: %name-common = %EVR
Provides: grub2-efi = %EVR
Obsoletes: grub2-efi < %EVR
PreReq: efibootmgr >= 15
%ifarch aarch64
Provides: grub2 = %EVR
Provides: grub = %EVR
%endif

%define desc_generic \
GNU GRUB is a multiboot boot loader. It was derived from GRUB. It is an \
attempt to produce a boot loader for IBM PC-compatible machines that \
has both the ability to be friendly to beginning or otherwise \
nontechnically interested users and the flexibility to help experts in \
diverse environments. It is compatible with Free/Net/OpenBSD and Linux. \
It supports Win 9x/NT and OS/2 via chainloaders. It has a menu \
interface and a command line interface. \
It implements the Multiboot standard, which allows for flexible loading \
of multiple boot images (needed for modular kernels such as the GNU Hurd).

%description
%desc_generic

%description common
%desc_generic

This package carries the shared code and data.

%description pc
%desc_generic

This package provides PC BIOS support.

%description efi
%desc_generic

This package provides UEFI systems support.

Please note that the official build is signed; this shouldn't
intervene in any way but rather provides means to cope with
UEFI SecureBoot (better described as Restricted Boot) firmware
when one can't disable it easily, doesn't want to, or needs not to.

%prep
%setup -b 5
%patch0 -p2
%patch1 -p1
%patch2 -p2
%patch3 -p1
%patch4 -p2
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p2
%patch14 -p2
%patch15 -p2
%patch16 -p1
%patch17 -p1
%patch18 -p1

sed -i "/^AC_INIT(\[GRUB\]/ s/%version[^]]\+/%version-%release/" configure.ac

%ifarch %ix86 x86_64
cd ..
rm -rf %name-pc-%version
cp -a %name-%version %name-pc-%version
%ifarch x86_64
rm -rf %name-ia32-%version
cp -a %name-%version %name-ia32-%version
cp -a %SOURCE11 %name-ia32-%version
%endif
%endif

%build
%ifarch %ix86 x86_64
pushd ../%name-pc-%version
./autogen.sh
%configure \
	TARGET_LDFLAGS=-static \
	--with-platform=pc \
	--disable-werror

%make_build
popd

#add forced ia32 version build to be bundled with x86_64 EFI
%ifarch x86_64
pushd ../%name-ia32-%version
./autogen.sh
%configure \
        TARGET_LDFLAGS=-static \
        --with-platform=efi \
        --disable-werror \
	--target=i386

%make_build

popd
%endif
%endif

./autogen.sh
%configure \
	TARGET_LDFLAGS=-static \
	--with-platform=efi \
	--disable-werror

%make_build

./grub-mkimage -O %grubefiarch -o grubx64.efi -d grub-core -p "" \
	part_gpt part_apple part_msdos hfsplus fat ext2 btrfs xfs squash4 normal chain boot configfile diskfilter \
%ifarch x86_64
linuxefi \
%else
linux \
%endif
	minicmd reboot halt search search_fs_uuid search_fs_file search_label sleep test syslinuxcfg all_video video \
	font gfxmenu gfxterm gfxterm_background lvm lsefi efifwsetup cat gzio iso9660 loadenv loopback mdraid09 mdraid1x \
	png jpeg

%ifarch x86_64
pushd ../%name-ia32-%version
../%name-%version/grub-mkimage -O i386-efi -o ./grubia32.efi -d ./grub-core -p "" \
        -c embedded_grub.cfg \
        part_gpt part_apple part_msdos hfsplus fat ext2 btrfs xfs squash4 normal chain boot configfile linuxefi diskfilter \
        minicmd reboot halt search search_fs_uuid search_fs_file search_label sleep test syslinuxcfg all_video video \
        font gfxmenu gfxterm gfxterm_background lvm lsefi efifwsetup cat gzio iso9660 loadenv loopback mdraid09 mdraid1x \
        png jpeg
popd
%endif

%install
%ifarch %ix86 x86_64
%makeinstall_std -C ../%name-pc-%version
%ifarch x86_64
pushd ../%name-ia32-%version
#"cherry pick" only i386 executable
install -pDm644 grubia32.efi %buildroot%_efi_bindir/grubia32.efi

#install ia32 version in parallel with x64 for x86_64 platforms with ia32 EFI
%makeinstall_std -C ../%name-ia32-%version
popd
%endif
%endif
%makeinstall_std

install -pDm644 %SOURCE1 %buildroot%_sysconfdir/sysconfig/grub2

%find_lang grub

mkdir -p %buildroot/boot/grub/fonts

install -pD -m755 %SOURCE8 %buildroot%_sbindir/
install -pD -m644 %SOURCE9 %buildroot%_man8dir/update-grub.8

# TODO: drop the obsolete one (unifont.pf2)
%buildroot%_bindir/grub-mkfont -o %buildroot/boot/grub/unifont.pf2 %_datadir/fonts/bitmap/misc/8x13.pcf.gz
%buildroot%_bindir/grub-mkfont -o %buildroot/boot/grub/fonts/unicode.pf2 %font

mkdir -p %buildroot/boot/grub/themes

install -pDm755 %SOURCE3 %buildroot%_sysconfdir/grub.d/
sed -i 's,^libdir=,libdir=%_libdir,g' %buildroot%_sysconfdir/grub.d/39_memtest
sed -i 's,@LOCALEDIR@,%_datadir/locale,g' %buildroot%_sysconfdir/grub.d/*

install -pDm755 %SOURCE4  %buildroot%_rpmlibdir/grub.filetrigger
install -pDm755 %SOURCE6  %buildroot%_sbindir/grub-autoupdate
install -pDm755 %SOURCE10 %buildroot%_sbindir/grub-efi-autoupdate

# Ghost config file
install -d %buildroot/boot/grub
touch %buildroot/boot/grub/grub.cfg
ln -s ../boot/grub/grub.cfg %buildroot%_sysconfdir/grub.cfg

# Docs/habits compat symlink
mkdir -p %buildroot%_sysconfdir/default
ln -s ../sysconfig/grub2 %buildroot%_sysconfdir/default/grub

install -pDm644 grubx64.efi %buildroot%_efi_bindir/grubx64.efi

# NB: UEFI GRUB2 image gets signed when build environment is set up that way
%ifarch x86_64
%pesign -s -i %buildroot%_efi_bindir/grubx64.efi
%pesign -s -i %buildroot%_efi_bindir/grubia32.efi
%endif

# Remove headers
rm -f %buildroot%_libdir/grub-efi/*/*.h

%files common -f grub.lang
%dir %_sysconfdir/grub.d
%dir %_libdir/grub
%dir /boot/grub
/boot/grub/*.pf2
/boot/grub/fonts/
/boot/grub/themes/
%_sysconfdir/grub.d/00_header
%_sysconfdir/grub.d/05_altlinux_theme
%_sysconfdir/grub.d/10_linux
%_sysconfdir/grub.d/20_linux_xen
%_sysconfdir/grub.d/30_os-prober
%_sysconfdir/grub.d/30_uefi-firmware
%_sysconfdir/grub.d/39_memtest
%config(noreplace) %_sysconfdir/grub.d/40_custom
%config(noreplace) %_sysconfdir/sysconfig/grub2
%ghost %config(noreplace) /boot/grub/grub.cfg
%_sysconfdir/grub.cfg
%_sysconfdir/default/grub
%_sysconfdir/bash_completion.d/grub
%_rpmlibdir/%name.filetrigger
# these tools are only for efi and x86_64
%ifarch x86_64
%_bindir/grub-render-label
%_sbindir/grub-bios-setup
%_sbindir/grub-macbless
%endif
%_sbindir/grub-install
%_sbindir/grub-mkconfig
%_sbindir/grub-ofpathname
%_sbindir/grub-probe
%_sbindir/grub-reboot
%_sbindir/grub-set-default
%_sbindir/grub-sparc64-setup
%_sbindir/update-grub
%_bindir/grub-editenv
%_bindir/grub-file
%_bindir/grub-fstest
%_bindir/grub-glue-efi
%_bindir/grub-kbdcomp
%_bindir/grub-menulst2cfg
%_bindir/grub-mknetdir
%_bindir/grub-mkstandalone
%_bindir/grub-mkfont
%_bindir/grub-mklayout
%_bindir/grub-mkimage
%_bindir/grub-mkpasswd-pbkdf2
%_bindir/grub-mkrelpath
%_bindir/grub-mkrescue
%_bindir/grub-script-check
%_bindir/grub-syslinux2cfg
%_datadir/grub/grub-mkconfig_lib
%_man1dir/*
%ifarch x86_64
%exclude %_man1dir/grub-render-label*
%exclude %_man8dir/grub-bios-setup*
%exclude %_man8dir/grub-macbless*
%endif
%_man8dir/*
%_infodir/grub.info.*
%_infodir/grub-dev.info.*

%ifarch %ix86 x86_64
%files pc
%_sbindir/grub-autoupdate
%_libdir/grub/*-pc/
%endif

%files efi
%_efi_bindir/grubx64.efi
%ifarch x86_64
%_efi_bindir/grubia32.efi
%_libdir/grub/i386-efi
%endif
%_sbindir/grub-efi-autoupdate
%_libdir/grub/%grubefiarch

%ifarch %ix86 x86_64
%post pc
grub-autoupdate || {
	echo "** WARNING: grub-autoupdate failed, NEXT BOOT WILL LIKELY FAIL NOW"
	echo "** WARNING: please run it by hand, record the output offline,"
	echo "** WARNING: make sure you have bootable rescue CD/flash media handy"
	echo "** WARNING: and try \`grub-install /dev/sdX' manually"
} >&2
%endif

%post efi
modprobe efivars
grep -q '^GRUB_DISTRIBUTOR=' %_sysconfdir/sysconfig/grub2 ||
	echo 'GRUB_DISTRIBUTOR="ALT Linux"' >> %_sysconfdir/sysconfig/grub2

grep -q '^GRUB_BOOTLOADER_ID=' %_sysconfdir/sysconfig/grub2 ||
	echo 'GRUB_BOOTLOADER_ID="altlinux"' >> %_sysconfdir/sysconfig/grub2

grub-efi-autoupdate || {
	echo "** WARNING: grub-efi-autoupdate failed, NEXT BOOT WILL LIKELY FAIL NOW"
	echo "** WARNING: please run grub-efi-autoupdate by hand, record the output offline,"
	echo "** WARNING: make sure you have e.g. rEFInd bootable media handy."
} >&2

%changelog
