Name: gsl90
Version: 1.16
Release: alt2.bzr20131023

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Summary: The GNU Scientific Library for numerical analysis
License: GPL
Group: Development/Other
URL: http://www.gnu.org/software/gsl/gsl.html

# bzr branch http://bzr.savannah.gnu.org/r/gsl/trunk/
Source: %name-%version.tar
Requires: lib%name = %version-%release
Conflicts: lib%name-devel < %version-%release

# Automatically added by buildreq on Wed Jun 06 2007
BuildRequires: ghostscript-module-X ghostscript-utils

#BuildPreReq: texlive-latex-recommended texlive-generic-recommended

%package -n lib%name
Summary: Shared librairies for Scientific Library
Group: System/Legacy libraries

%package -n lib%name-devel
Summary: Development environment for Scientific Library
Group: Development/C
Requires: lib%name = %version-%release
Conflicts: libgsl-devel

%package -n lib%name-doc
Summary: book for Scientific Library
Group: Documentation
BuildArch: noarch

%package -n lib%name-info
Summary: Info pages for Scientific Library
Group: Documentation
BuildArch: noarch
Conflicts: %name < %version-%release

%package -n lib%name-examples
Summary: Examples sources for using with Scientific Library
Group: Documentation
BuildArch: noarch

%description
The %name package is part of the GNU Scientific Library (GSL). The GSL is a
collection of routines for numerical analysis, written in C.  The GSL is
in alpha development.  It now includes a random number suite, an FFT
package, simulated annealing and root finding.  In the future, it will
include numerical and Monte Carlo integration and special functions.
Linking against the GSL allows programs to access functions which can
handle many of the problems encountered in scientific computing.

Install the %name package if you need utilities for high-level scientific
numerical analysis.

%description -n lib%name
The lib%name package is part of the GNU Scientific Library (GSL). The GSL is a
collection of routines for numerical analysis, written in C.  The GSL is
in alpha development.  It now includes a random number suite, an FFT
package, simulated annealing and root finding.  In the future, it will
include numerical and Monte Carlo integration and special functions.
Linking against the GSL allows programs to access functions which can
handle many of the problems encountered in scientific computing.

This package contains shared library required for run GSL-based software.

%description -n lib%name-devel
The lib%name-devel package is part of the GNU Scientific Library (GSL). The GSL is a
collection of routines for numerical analysis, written in C.  The GSL is
in alpha development.  It now includes a random number suite, an FFT
package, simulated annealing and root finding.  In the future, it will
include numerical and Monte Carlo integration and special functions.
Linking against the GSL allows programs to access functions which can
handle many of the problems encountered in scientific computing.

This package contains shared libs and include headers required for development.

%description -n lib%name-doc
book for developers

%description -n lib%name-info
Info pages for GSL

%description -n lib%name-examples
Sources of examples for using with GSL

%prep
%setup

%build
./autogen.sh
%configure
sed -i 's|\(GSL_MINOR_VERSION.*\)+|\1|' gsl_version.h
%make_build

pushd doc
    #make ps
    #ps2pdf gsl-ref.ps
		%make gsl-ref.html
popd

%install
%makeinstall

install -d %buildroot%_docdir/lib%name-%version/examples
#install -m644 doc/gsl-ref.pdf %buildroot%_docdir/lib%name-%version
cp -fR doc/gsl-ref.html %buildroot%_docdir/lib%name-%version/
install -p -m644 doc/examples/* %buildroot%_docdir/lib%name-%version/examples
bzip2 ChangeLog
bzip2 NEWS
install -p -m644 ChangeLog.* NEWS.* AUTHORS README THANKS TODO \
	DONE VOLUNTEERS NOTES \
	%buildroot%_docdir/lib%name-%version

%if 0
%files
%_bindir/*
%exclude %_bindir/%name-config
%_man1dir/*
%exclude %_man1dir/%name-config.1*
%endif

%files -n lib%name
%doc %dir %_docdir/lib%name-%version
%doc %_docdir/lib%name-%version/AUTHORS
%_libdir/*.so.*

%files -n lib%name-devel
%_bindir/gsl-config
%_libdir/*.so
%_libdir/pkgconfig/*
%_includedir/*
%_datadir/aclocal/*
%_man1dir/gsl-config.1*
%_man3dir/*

%if 0
%files -n lib%name-doc
%doc %dir %_docdir/lib%name-%version
%doc %_docdir/lib%name-%version/*
%exclude %_docdir/lib%name-%version/AUTHORS
%exclude %_docdir/lib%name-%version/examples

%files -n lib%name-info
%_infodir/*.info*

%files -n lib%name-examples
%doc %dir %_docdir/lib%name-%version
%doc %_docdir/lib%name-%version/examples
%endif

%changelog
