%define _gst_libdir %_libdir/gstreamer-%ver_major
%define gst_plugins gst-plugins
%define ver_major 0.10

Name: gst-ffmpeg
Version: %ver_major.13
Release: alt1
Summary: GStreamer streaming media framework plug-in using FFmpeg
Group: System/Libraries
License: GPL
Url: http://gstreamer.freedesktop.org/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar
Source1: common.tar
Patch: %name-%version-%release.patch

BuildRequires: bzlib-devel gcc-c++ gst-plugins-devel gtk-doc libavformat-devel liboil-devel
BuildRequires: liborc-devel libpostproc-devel libswscale-devel python-modules zlib-devel

%description
GStreamer is a streaming-media framework, based on graphs of filters
which operate on media data. Applications using this library can do
anything from real-time sound processing to playing videos, and just
about anything else media-related. Its plugin-based architecture means
that new data types or processing capabilities can be added simply by
installing new plug-ins.

GStreamer FFmpeg plug-in contains one plugin with a set of elements
using the FFmpeg library code. It contains most popular decoders as
well as very fast colorspace conversion elements.

%prep
%setup -q -a1
%patch -p1

touch ABOUT-NLS config.rpath

%build
%autoreconf
%configure \
    --disable-static \
    --with-system-ffmpeg

%make_build

%install
%make DESTDIR=%buildroot install

%files
%doc AUTHORS NEWS README TODO
%_gst_libdir/*.so

%changelog
