%define ver_major 1.12
%define gst_api_ver 1.0
%define _gst_libdir %_libdir/gstreamer-%gst_api_ver
# switched from libav to ffmpeg since 1.5.90
# was 11.4 for libav fork
%define libav_ver 3.0
#%%if "%(rpmvercmp '%{get_version libavformat-devel}' '3.0.0')" > "0"
%def_without system_libav
#%%endif
%if_without system_libav
%set_verify_elf_method textrel=relaxed
%endif

Name: gst-libav
Version: %ver_major.3
Release: alt0.M80P.1

Summary: GStreamer (%gst_api_ver API) streaming media framework plug-in using FFmpeg
Group: System/Libraries
License: GPL
Url: http://gstreamer.freedesktop.org/

Source: http://gstreamer.freedesktop.org/src/%name/%name-%version.tar.xz

BuildRequires: gst-plugins%gst_api_ver-devel >= %ver_major
BuildRequires: orc liborc-devel zlib-devel bzlib-devel liblzma-devel gtk-doc
%if_with system_libav
BuildRequires: libavformat-devel >= %libav_ver
BuildRequires: libswscale-devel libavresample-devel libavfilter-devel
%else
BuildRequires: glibc-devel-static yasm
BuildRequires: libX11-devel libXext-devel libXvMC-devel libXfixes-devel
BuildRequires: libfreetype-devel libSDL-devel
BuildRequires: libgnutls-devel
BUildRequires: liblame-devel
BuildRequires: libvorbis-devel
BuildRequires: libcdio-devel libcdio-paranoia-devel
BuildRequires: libgsm-devel
BuildRequires: libpulseaudio-devel
BuildRequires: libxvid-devel
BuildRequires: libx264-devel
BuildRequires: libx265-devel
BuildRequires: libdc1394-devel libraw1394-devel
BuildRequires: libschroedinger-devel
BuildRequires: libtheora-devel
BuildRequires: bzlib-devel
BuildRequires: liblzo2-devel
BuildRequires: libva-devel
BuildRequires: libvdpau-devel
BuildRequires: libopencore-amrwb-devel
BuildRequires: libopencore-amrnb-devel
BuildRequires: libvpx-devel
BuildRequires: libv4l-devel
BuildRequires: librtmp-devel
BuildRequires: frei0r-devel
BuildRequires: libspeex-devel
%endif

%description
GStreamer is a streaming-media framework, based on graphs of filters
which operate on media data. Applications using this library can do
anything from real-time sound processing to playing videos, and just
about anything else media-related. Its plugin-based architecture means
that new data types or processing capabilities can be added simply by
installing new plug-ins.

GStreamer Libav plug-in contains one plugin with a set of elements
using the FFmpeg library code. It contains most popular decoders as
well as very fast colorspace conversion elements.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch

%description devel-doc
This package contains development documentation for the GStreamer Libav
plug-in.

%prep
%setup

%build
%autoreconf
%configure \
    --disable-static \
    %{?_with_system_libav:--with-system-libav}

%make_build

%install
%makeinstall_std

%files
%_gst_libdir/*.so
%exclude %_gst_libdir/*.la
%doc AUTHORS NEWS README TODO

%files devel-doc
%_datadir/gtk-doc/html/%name-plugins-%gst_api_ver/

%changelog
