%def_enable ladspa
%def_enable libdc1394
%def_enable libkate
%def_enable mjpegtools
%def_enable opencv
%def_enable timidity
%def_enable vulkan
%def_enable wayland
%def_enable zbar

%define _name gst-plugins
%define api_ver 1.0
%define ver_major 1.12

%define _gst_libdir %_libdir/gstreamer-%api_ver
%define _gtk_docdir %_datadir/gtk-doc/html

%def_enable gtk_doc

Name: %_name-bad%api_ver
Version: %ver_major.3
Release: alt0.M80P.1

Summary: A set of GStreamer plugins that need more quality
Group: System/Libraries
License: LGPL
Url: http://gstreamer.freedesktop.org/

Requires: lib%_name%api_ver >= %ver_major
Requires: gstreamer%api_ver >= %ver_major

Source: http://gstreamer.freedesktop.org/src/%_name-bad/%_name-bad-%version.tar.xz
Patch: gst-plugins-bad-0.11.94-alt-intltool.patch

BuildRequires: gst-plugins%api_ver-devel gst-plugins%api_ver-gir-devel
BuildRequires: bzlib-devel gcc-c++ gtk-doc intltool libSDL-devel libX11-devel
BuildRequires: libalsa-devel libcdaudio-devel libdca-devel libdirac-devel libdvdnav-devel libexif-devel
BuildRequires: libfaad-devel libgio-devel libgsm-devel libjasper-devel libmms-devel
%{?_enable_mjpegtools:BuildRequires: libmjpegtools-devel}
BuildRequires: libmpcdec-devel libneon-devel liboil-devel libsoundtouch-devel libssl-devel libmodplug-devel
BuildRequires: libcelt-devel libxvid-devel python-module-PyXML python-modules-email python-modules-encodings
%{?_enable_timidity:BuildRequires: libtimidity-devel timidity-instruments}
%{?_enable_libkate:BuildRequires: libkate-devel libtiger-devel}
%{?_enable_libdc1394:BuildRequires: libdc1394-devel}
BuildRequires: libvpx-devel librtmp-devel liborc-devel orc libofa-devel libmusicbrainz-devel libass-devel
%{?_enable_wayland:BuildRequires: libwayland-client-devel libwayland-cursor-devel libwayland-egl-devel wayland-protocols}
%{?_enable_zbar:BuildRequires: libzbar-devel}
BuildRequires: libEGL-devel libwebp-devel libopenjpeg2.0-devel libbluez-devel
BuildRequires: libdbus-devel libxml2-devel libgnutls-devel libvdpau-devel
BuildRequires: libsbc-devel libschroedinger-devel libusb-devel libgudev-devel libopus-devel
BuildRequires: libcurl-devel libssh2-devel
BuildRequires: libvo-amrwbenc-devel librsvg-devel libvo-aacenc-devel libgcrypt-devel
BuildRequires: gobject-introspection-devel libgstreamer1.0-gir-devel
BuildRequires: libvisual0.4-devel openexr-devel libx265-devel
BuildRequires: libgtk+3-devel libclutter-devel
%{?_enable_opencv:BuildRequires: libopencv-devel}
%{?_enable_ladspa:BuildRequires: ladspa_sdk liblrdf-devel libfluidsynth-devel}
%{?_enable_vulkan:BuildRequires: vulkan-devel}

%description
GStreamer Bad Plug-ins is a set of plug-ins that aren't up to par
compared to the rest.  They might be close to being good quality, but
they're missing something - be it a good code review, some
documentation, a set of tests, a real live maintainer, or some actual
wide use.  If the blanks are filled in they might be upgraded to
become part of either gst-plugins-good or gst-plugins-ugly, depending
on the other factors.

%package devel
Summary: Development files for GStreamer plugins
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains the libraries, headers and other files necessary
to develop GStreamer Bad Plug-ins.

%package doc
Summary: Documentation for %name
Group: Documentation
BuildArch: noarch

%description doc
This package contains documentation for GStreamer Bad Plug-ins.

%prep
%setup -n %_name-bad-%version
%patch -p1

%build
%autoreconf

%if_enabled opencv
# broken opencv.pc
%define opencv_libs %(pkg-config --libs opencv |sed -e 's|%_libdir/lib|-l|g' |sed -e 's|\.so||g')
%endif

%configure \
    --disable-examples \
    --enable-experimental \
    %{subst_enable gtk_doc} \
    --disable-static \
    --with-html-dir=%_gtk_docdir \
    %{?_enable_opencv:OPENCV_LIBS="%opencv_libs"}

%make_build

%install
%makeinstall_std

%find_lang %_name-bad-%api_ver

%files -f %_name-bad-%api_ver.lang
%doc AUTHORS NEWS README RELEASE
%_libdir/*.so.*
%dir %_gst_libdir
%_gst_libdir/*.so
%exclude %_gst_libdir/*.la
#%_typelibdir/GstEGL-%api_ver.typelib
%_typelibdir/GstBadAllocators-%api_ver.typelib
%_typelibdir/GstGL-%api_ver.typelib
%_typelibdir/GstInsertBin-%api_ver.typelib
%_typelibdir/GstMpegts-%api_ver.typelib
%_typelibdir/GstPlayer-%api_ver.typelib
%_datadir/gstreamer-%api_ver/presets/GstVoAmrwbEnc.prs
%_datadir/gstreamer-%api_ver/presets/GstFreeverb.prs
%if_enabled opencv
%_datadir/gst-plugins-bad/%api_ver/opencv_haarcascades/fist.xml
%_datadir/gst-plugins-bad/%api_ver/opencv_haarcascades/palm.xml
%endif
#%_datadir/gstreamer-%api_ver/presets/GstVP8Enc.prs
#%_datadir/glib-2.0/schemas/*.xml

%files devel
%_includedir/gstreamer-%api_ver/*
%_libdir/gstreamer-%api_ver/include/gst/gl/gstglconfig.h
%_libdir/*.so
%_pkgconfigdir/*.pc
#%_girdir/GstEGL-%api_ver.gir
%_girdir/GstBadAllocators-%api_ver.gir
%_girdir/GstGL-%api_ver.gir
%_girdir/GstInsertBin-%api_ver.gir
%_girdir/GstMpegts-%api_ver.gir
%_girdir/GstPlayer-%api_ver.gir

%if_enabled gtk_doc
%files doc
%_gtk_docdir/gst-plugins-bad-plugins-%api_ver
%_gtk_docdir/gst-plugins-bad-libs-%api_ver
%endif

%changelog
