%define _name gst-plugins
%define ver_major 1.12
%define api_ver 1.0

%define _gst_datadir %_datadir/gstreamer-%api_ver
%define _gst_libdir %_libdir/gstreamer-%api_ver
%define _gtk_docdir %_datadir/gtk-doc/html

%def_enable gtk_doc
%def_enable jack
%def_enable pulse

Name: %_name-good%api_ver
Version: %ver_major.3
Release: alt0.M80P.1

Summary: A set of GStreamer plugins considered good
Group: System/Libraries
License: LGPL
URL: http://gstreamer.freedesktop.org/

Source: http://gstreamer.freedesktop.org/src/%_name-good/%_name-good-%version.tar.xz
Patch: gst-plugins-good-0.11.94-alt-intltool.patch

BuildRequires: bzlib-devel gcc-c++ gst-plugins%api_ver-devel gtk-doc intltool libSM-devel libXdamage-devel libXext-devel libXfixes-devel
BuildRequires: libXv-devel libavc1394-devel libcairo-devel libdv-devel libflac-devel libiec61883-devel libjpeg-devel
BuildRequires: liboil-devel libshout2-devel libsoup-devel libtag-devel libv4l-devel libwavpack-devel
BuildRequires: python-module-PyXML python-modules-email python-modules-encodings liborc-devel orc libgdk-pixbuf-devel
BuildRequires: libpng-devel libcairo-gobject-devel libgudev-devel libspeex-devel zlib-devel libvpx-devel
%{?_enable_jack:BuildRequires: libjack-devel}
%{?_enable_pulse:BuildRequires: libpulseaudio-devel}

%description
GStreamer Good Plug-ins is is a set of plug-ins that the developers consider
to have good quality code, correct functionality, and their preferred license
(LGPL for the plug-in code, LGPL or LGPL-compatible for the supporting
library).

%package devel-doc
Summary: Development documentation for GStreamer Good plugins
Group: Development/Documentation
BuildArch: noarch

%description devel-doc
This package contains development documentation for GStreamer Good Plugins

%prep
%setup -n %_name-good-%version
%patch -p1

%build
%autoreconf
%configure \
	--enable-experimental \
	--disable-examples \
	--disable-valgrind \
	--disable-oss \
	--disable-oss4 \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	--disable-debug \
	--disable-static
%make_build

%install
%makeinstall_std

%find_lang %_name-good-%api_ver

%files -f %_name-good-%api_ver.lang
%_gst_libdir/*.so
%exclude %_gst_libdir/*.la
%_gst_datadir/*
%doc AUTHORS NEWS README RELEASE

%files devel-doc
%_gtk_docdir/*

%changelog
