%define ver_major 0.10
%define _libexecdir %_prefix/libexec

Name: gstreamer
Version: %ver_major.36
Release: alt1
Summary: GStreamer streaming media framework runtime
License: LGPL
Group: System/Libraries
URL: http://gstreamer.freedesktop.org
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: lib%name = %version-%release

Source: %name-%version.tar
Source1: common.tar
Patch: %name-%version-%release.patch

BuildRequires: docbook-utils flex gcc-c++ ghostscript-utils glib2-devel gtk-doc intltool libcheck-devel libxml2-devel
BuildRequires: python-modules sgml-common transfig xml-utils gobject-introspection-devel

%description
GStreamer is a streaming-media framework, based on graphs of filters which
operate on media data. Applications using this library can do anything
from real-time sound processing to playing videos, and just about anything
else media-related.  Its plugin-based architecture means that new data
types or processing capabilities can be added simply by installing new
plugins.

%package -n lib%name
Summary: Shared libraries of GStreamer
Group: System/Libraries

%description -n lib%name
This package contains the shared libraries of the GStreamer media framework

%package -n lib%name-gir
Summary: GObject introspection data for the GStreamer library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the GStreamer library

%package devel
Summary: Development files for GStreamer streaming-media framework
Group: Development/C
Requires: lib%name = %version-%release

%description devel
This package contains the libraries and header files necessary to
develop applications and plugins for GStreamer

%package gir-devel
Summary: GObject introspection devel data for the GStreamer library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the GStreamer library

%package devel-doc
Summary: Development documentation for GStreamer
Group: Development/C
BuildArch: noarch

%description devel-doc
This package contains development documentation for GStreamer

%package doc
Summary: Documentation for GStreamer
Group: Documentation
BuildArch: noarch

%description doc
This package contains documentation for GStreamer

%package utils
Summary: GStreamer utilities
Group: System/Libraries
Requires: lib%name = %version-%release

%description utils
This package contains some utilities used to register, analyze, and run
Gstreamer plugins.

%prep
%setup -q -a1
%patch -p1

touch ABOUT-NLS config.rpath
subst '/.PHONY/d' Makefile.am

%build
%autoreconf
%configure \
	--with-package-name=GStreamer \
	--with-package-origin=%name \
	--disable-examples \
	--disable-valgrind \
	--enable-docbook \
	--enable-gtk-doc \
	--disable-rpath \
	--disable-tests \
	--disable-debug \
	--disable-static

%make_build

%install
%make DESTDIR=%buildroot install

%find_lang %name-%ver_major

%files -f %name-%ver_major.lang
%doc AUTHORS NEWS README RELEASE
%_libexecdir/%name-%ver_major
%dir %_libdir/%name-%ver_major
%_libdir/%name-%ver_major/*.so

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-gir
%_libdir/girepository-1.0/*.typelib

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/aclocal/*

%files gir-devel
%_datadir/gir-1.0/*.gir

%files devel-doc
%_datadir/gtk-doc/html/*

%files utils
%_bindir/*
%_man1dir/*

%files doc
%_datadir/doc/%name-%ver_major

%changelog
