%define _name gstreamer
%define ver_major 1.12
%define api_ver 1.0
%define _libexecdir %_prefix/libexec
%define api_ver 1.0

%def_enable gtk_doc

Name: %_name%api_ver
Version: %ver_major.3
Release: alt0.M80P.1

Summary: GStreamer streaming media framework runtime
License: LGPL
Group: System/Libraries
URL: http://gstreamer.freedesktop.org

Requires: lib%name = %version-%release libcap-utils

Source: http://gstreamer.freedesktop.org/src/%_name/%_name-%version.tar.xz
Patch: %_name-0.11.94-alt-intltool.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=787587
Patch1: gstreamer-1.12.3-up-e2k.patch

%define glib_ver 2.40.0

BuildRequires: glib2-devel >= %glib_ver
BuildRequires: flex gcc-c++ ghostscript-utils gtk-doc intltool libcheck-devel libxml2-devel
BuildRequires: python-modules sgml-common transfig xml-utils gobject-introspection-devel
BuildRequires: libcap-utils

%description
GStreamer is a streaming-media framework, based on graphs of filters which
operate on media data. Applications using this library can do anything
from real-time sound processing to playing videos, and just about anything
else media-related.  Its plugin-based architecture means that new data
types or processing capabilities can be added simply by installing new
plugins.

%package -n lib%name
Summary: Shared libraries of GStreamer
Group: System/Libraries

%description -n lib%name
This package contains the shared libraries of the GStreamer media framework

%package -n lib%name-gir
Summary: GObject introspection data for the GStreamer library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the GStreamer library

%package devel
Summary: Development files for GStreamer streaming-media framework
Group: Development/C
Requires: lib%name = %version-%release

%description devel
This package contains the libraries and header files necessary to
develop applications and plugins for GStreamer

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the GStreamer library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release %name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the GStreamer library

%package devel-doc
Summary: Development documentation for GStreamer
Group: Development/C
BuildArch: noarch

%description devel-doc
This package contains development documentation for GStreamer

%package utils
Summary: GStreamer utilities
Group: System/Libraries
Requires: lib%name = %version-%release

%description utils
This package contains some utilities used to register, analyze, and run
Gstreamer plugins.

%prep
%setup -n %_name-%version
%patch -p1
%patch1 -p1

%build
%autoreconf
%ifarch e2k
# till lcc ~1.23
export LIBS=-lcxa
%endif
%configure \
	--with-package-name=GStreamer \
	--with-package-origin=%name \
	--disable-examples \
	--disable-valgrind \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	--disable-gtk-doc-pdf \
	--disable-rpath \
	--disable-tests \
	--disable-debug \
	--disable-static \
	--with-bash-completion-dir=no
%make_build

%install
%makeinstall_std

%find_lang %_name-%api_ver

%post
setcap cap_net_bind_service,cap_net_admin+ep %_libexecdir/%_name-%api_ver/gst-ptp-helper 2>/dev/null ||:

%files -f %_name-%api_ver.lang
%dir %_libexecdir/%_name-%api_ver
%_libexecdir/%_name-%api_ver/gst-plugin-scanner
%_libexecdir/%_name-%api_ver/gst-ptp-helper
%dir %_libdir/%_name-%api_ver
%_libdir/%_name-%api_ver/*.so
%exclude %_libdir/%_name-%api_ver/*.la
%doc AUTHORS NEWS README RELEASE

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-gir
%_typelibdir/Gst-%api_ver.typelib
%_typelibdir/GstBase-%api_ver.typelib
%_typelibdir/GstCheck-%api_ver.typelib
%_typelibdir/GstController-%api_ver.typelib
%_typelibdir/GstNet-%api_ver.typelib

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/aclocal/*

%files -n lib%name-gir-devel
%_girdir/Gst-%api_ver.gir
%_girdir/GstBase-%api_ver.gir
%_girdir/GstCheck-%api_ver.gir
%_girdir/GstController-%api_ver.gir
%_girdir/GstNet-%api_ver.gir

%files devel-doc
%_datadir/gtk-doc/html/*

%files utils
%_bindir/*
%_man1dir/*

%changelog
