%def_disable snapshot

%define ver_base 3.5
%define ver_major 3.5
%define gst_api_ver 1.0
%define xdg_name org.gnome.gThumb

%def_enable debug
%def_enable exiv2
%def_enable libbrasero
%def_enable web_albums
%def_disable libchamplain
%def_enable libraw

Name: gthumb
Version: %ver_major.3
Release: alt0.M80P.1

Summary: An image file viewer and browser for GNOME
Summary(ru_RU.UTF-8): Просмотрщик изображений и фотоальбом для GNOME

License: GPL
Group: Graphics
Url: http://gthumb.sourceforge.net/

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%endif

# From configure.ac
%define glib_ver 2.38.0
%define gtk_ver 3.10.0
%define clutter_gtk_ver 1.0.0
%define gst_ver 1.0
%define exiv2_ver 0.20
%define libraw_ver 0.16
%define brasero_ver 3.2.0
%define soup_ver 2.42
%define gnome_common_ver 2.8.0
%define webp_ver 0.2.0
%define webkit_ver 2.6.0
%define champlain_ver 0.12.0
%define desktop_file_utils_ver 0.8

Requires: %name-data = %version-%release

# From configure.ac
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libclutter-devel libclutter-gtk3-devel >= %clutter_gtk_ver
BuildPreReq: gstreamer%gst_api_ver-devel >= %gst_ver gst-plugins%gst_api_ver-devel >= %gst_ver
BuildRequires: libjpeg-devel libpng-devel libtiff-devel zlib-devel
BuildRequires: libsoup-devel >= %soup_ver libsecret-devel
BuildRequires: librsvg-devel intltool perl-XML-Parser gnome-common yelp-tools
BuildRequires: gsettings-desktop-schemas-devel libwebp-devel >= %webp_ver libjson-glib-devel
BuildRequires: libwebkitgtk4-devel >= %webkit_ver
%{?_enable_libraw:BuildPreReq: libraw-devel >= %libraw_ver libgomp-devel}
%{?_enable_libbrasero:BuildRequires: libbrasero-devel >= %brasero_ver}
%{?_enable_web_albums:BuildRequires: bison flex}
%{?_enabled_libchamplain:BuildRequires: libchamplain-gtk3-devel >= %champlain_ver}

%if_enabled exiv2
BuildPreReq: libexiv2-devel >= %exiv2_ver gcc-c++
%endif

BuildPreReq: libjpeg-devel libtiff-devel libXrender-devel libXext-devel libX11-devel
BuildPreReq: libXtst-devel libXxf86vm-devel gnome-doc-utils libXi-devel
BuildRequires: libSM-devel libICE-devel

BuildRequires: desktop-file-utils >= %desktop_file_utils_ver
BuildRequires: gnome-common >= %gnome_common_ver
BuildRequires: libappstream-glib-devel

%description
gThumb lets you browse your hard disk, showing thumbnails of image
files. It also lets view single files (including GIF animations),
add comments to images, organize images in catalogs, print images, view
slideshows, set desktop background, and more.

%description -l ru_RU.UTF-8
gThumb позволяет просматривать содержимое жёсткого диска, показывая
уменьшенные копии содержимого графических файлов. Также программа
позволяет просматривать отдельные изображения (включая мультфильмы в
формате GIF), добавлять комментарии к картинкам, раскладывать картинки
по каталогам, печатать, автоматически пролистывать серии картинок,
менять фон рабочего стола и многое другое.

%package data
Summary: Arch independent files for gThumb
Group: Graphics
BuildArch: noarch

%description data
This package provides noarch data needed for gThumb to work.

%package devel
Summary: gThumb development files
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains headers needed to build extensions for gThumb.

%prep
%setup

%build
%autoreconf
%configure \
    --enable-jpeg \
    --enable-tiff \
    %{subst_enable exiv2} \
    %{subst_enable debug} \
    %{subst_enable libbrasero} \
    %{subst_enable libchamplain} \
    %{subst_enable libraw} \
    --disable-static \
    --disable-schemas-compile \

%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%files
%_bindir/*
%dir %_libdir/gthumb/extensions
%_libdir/gthumb/extensions/*
%exclude %_libdir/%name/extensions/*.la

%files data  -f %name.lang
%_desktopdir/*
%_datadir/%name/
%_iconsdir/hicolor/*/*/*
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.change-date.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.comments.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.contact-sheet.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.convert-format.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.crop.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.enums.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.facebook.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.file-manager.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.flickr.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.gstreamer-tools.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.image-print.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.image-viewer.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.importer.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.photo-importer.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.picasaweb.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.pixbuf-savers.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.rename-series.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.resize.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.resize-images.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.rotate.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.slideshow.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.webalbums.gschema.xml
%_datadir/GConf/gsettings/%name.convert
%_datadir/appdata/%xdg_name.appdata.xml
%_man1dir/gthumb.1.*
%doc AUTHORS NEWS README

%files devel
%_includedir/gthumb-%ver_base/
%_datadir/aclocal/gthumb.m4
%_pkgconfigdir/*

%changelog
