Name: gtk+
Version: 1.2.10
Release: alt23

Summary: The GIMP ToolKit (GTK+), a library for creating GUIs for X
License: LGPL
Group: System/Libraries
Url: http://www.gtk.org/

Source0: ftp://ftp.gimp.org/pub/gtk/v1.2/gtk+-%version.tar
Source1: gtkrc_utf8.tar
Patch1: gtk+-1.2.9-be.patch
Patch2: gtk+-1.2.9-rc.patch
Patch3: gtk+-1.2.9-rc2.patch
Patch4: gtk+-1.2.8-advanced-gtkfilesel.patch
Patch5: gtk+-1.2.10-rh-encoding.patch
Patch6: gtk+-1.2.10-alt-linkage.patch
Patch7: gtk+-1.2.10-rh-m4.patch
Patch8: gtk+-1.2.10-rh-clistfocusrow.patch
Patch9: gtk+-1.2.10-rh-bellvolume.patch

# (fc) 1.2.10-2mdk ximian patch changing drawing when no shadow is set for menubar
Patch102: gtk+-1.2.6-ximian-noborder.patch
# (pablo) better gtkrc definitions
Patch103: gtk+-1.2.10-mdk-gtkrc_files.patch
# (fc) 1.2.10-8mdk GNOME CVS patch correcting bad focus (seen in Evolution and gnomecc)
Patch104: gtk+-1.2.10-cvs-focus.patch
# (pablo) load locale based gtkrc (GNOME CVS)
Patch105: gtk+-1.2.10-cvs-rclocale.patch
# (fc) 1.2.10-10mdk fix alignement warning on ia64 (Rawhide)
Patch106: gtk+-1.2.10-rh-alignment.patch
# (fc) 1.2.10-10mdk Improve exposure compression (GNOME CVS)
Patch107: gtk+-1.2.10-cvs-expose.patch
# (fc) 1.2.10-10mdk Don't screw up CTEXT encoding for UTF-8 (Rawhide)
Patch108: gtk+-1.2.10-rh-ctext.patch
# (fc) 1.2.10-10mdk Accept KP_Enter as a synonym for Return everywhere (Rawhide)
Patch109: gtk+-1.2.10-rh-kpenter.patch
# (fc) 1.2.10-10mdk Allow theme switching to work properly when no windows are realized (Rawhide)
Patch110: gtk+-1.2.10-mdk-themeswitch.patch
# (fc) 1.2.10-10mdk Fix crash when switching themes (Rawhide)
Patch111: gtk+-1.2.10-rh-pixmapref.patch
# (fc) 1.2.10-10mdk Fix computation of width of missing characters (Rawhide)
Patch112: gtk+-1.2.10-rh-missingchar.patch
# (fc) 1.2.10-20mdk set _NET_WM_PID on gdkwindow (GNOME CVS)
Patch115: gtk+-1.2.10-cvs-netwmpid.patch
# (fc) 1.2.10-22mdk fix Fix check of wrong variable on gtklabel (GNOME CVS)
Patch116: gtk+-1.2.10-cvs-labelvariable.patch
# (fc) 1.2.10-22mdk fix GtkCombo occasionally segfaults after content is changed and list shown (GNOME CVS) Bugzilla 58024
Patch117: gtk+-1.2.10-mdk-gtklist.patch
# (fc) 1.2.10-22mdk option menu doesn't appear centered when applied a border (GNOME CVS) Bugzilla 54585
Patch118: gtk+-1.2.10-cvs-border.patch
# (fc) 1.2.10-22mdk DnD code doesn't notice new windows (GNOME CVS) Bugzilla 56349
Patch119: gtk+-1.2.10-cvs-dndnewwindow.patch
# (fc) 1.2.10-26mdk don't set -L/usr/lib in gtk-config
Patch120: gtk+-1.2.10-mdk-libdir.patch
# (fc) 1.2.10-27mdk Fix file selection delete-dir when changing directory problem
# also, fix memory corruption problem when changing directories. (Rawhide)
Patch121: gtk+-1.2.10-rh-deletedir.patch 
# fc) 1.2.10-27mdk Improve warning for missing fonts (Rawhide)
Patch122: gtk+-1.2.10-rh-fontwarning.patch
# (fc) 1.2.10-27mdk Allow themes to make scrollbar trough always repaint (rawhide)
Patch123: gtk+-1.2.10-rh-troughpaint.patch
# (fc) 1.2.10-28mdk Fix a crash that can happen in some apps when the current
# locale is not supported by XLib. (rawhide)
Patch124: gtk+-1.2.10-rh-localecrash.patch
# (fc) 1.2.10-29mdk fix loop and crash in file selector when / is not readable (bug #90)
Patch125: gtk+-1.2.10-mdk-fileselectorfallback.patch
# (fc) 1.2.10-30mdk change default colors to match GTK2 2.2 colors
Patch126: gtk+-1.2.10-mdk-defaultcolor.patch
# (fc) 1.2.10-45mdv ugly hack to skip argb visuals
Patch128: gtk+-1.2.10-mdk-argb.patch
# (fc) CJK polish
Patch129: gtk+-1.2.10-ahiguti.patch
# (fc) PPC64
Patch130: gtk+-1.2.10-rh-ppc64.patch

%set_autoconf_version 2.13
%set_automake_version 1.4
%set_libtool_version  1.5

BuildPreReq: libtool_1.5 >= 3:1.5-alt10

# Automatically added by buildreq on Thu Feb 22 2007
BuildRequires: glib-devel glibc-devel-static imake libXi-devel libXt-devel xorg-cf-files

# it's also currently required by xorg-server-common
# but let's be explicit just in case
Requires: fonts-bitmap-misc
# explicitly added texinfo for info files
BuildRequires: texinfo

%package devel
Summary: Development tools for GTK+ (GIMP ToolKit) applications
Group: Development/GNOME and GTK+
Requires: %name = %version-%release
Requires: glib-devel libX11-devel

%package devel-static
Summary: Static libraries for GTK+ (GIMP ToolKit) applications
Group: Development/GNOME and GTK+
Requires: %name-devel = %version-%release

%description
This package contains the GIMP ToolKit (GTK+), a library for creating
graphical user interfaces for the X Window System.  GTK+ was originally
written for the GIMP (GNU Image Manipulation Program) image processing
program, but is now used by several other programs as well.

To use GTK1 in UTF-8 locales, you are advised to install these packages:
* fonts-bitmap-75dpi
* fonts-bitmap-cyrillic (for Cyrillic glyphs)

%description devel
The %name-devel package contains the header and support files needed for
developing GTK+ (GIMP ToolKit) applications.  The %name-devel package
contains GDK (the General Drawing Kit, which simplifies the interface for
writing GTK+ widgets and using GTK+ widgets in applications), and GTK+
(the widget set).

%description devel-static
This package contains the static libraries needed for developing
GTK+ (GIMP ToolKit) statically linked applications.

%prep
%setup

%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p0
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p0
%patch9 -p1

subst -p 's/az /az be /g' configure*

%patch102 -p1 -b .noshadow
#patch103 -p1 -b .gtkrc -- conflicts with rc.patch
%patch104 -p1 -b .focus
#patch105 -p1 -b .rclocale -- superseded by rh-encoding.patch
%patch106 -p1 -b .ia64
%patch107 -p1 -b .expose
%patch108 -p1 -b .ctext
%patch109 -p1 -b .kpenter
%patch110 -p1 -b .themeswitch
%patch111 -p1 -b .pixmapref
%patch112 -p1 -b .missingchar
%patch115 -p1 -b .netwmpid
%patch116 -p1 -b .labelvariable
%patch117 -p1 -b .gtklist
%patch118 -p1 -b .border
%patch119 -p1 -b .dndnewwindow
%patch120 -p1 -b .libdir
#patch121 -p1 -b .deletedir -- conflicts with advanced-gtkfilesel.patch
%patch122 -p1 -b .fontwarning
%patch123 -p1 -b .troughpaint
%patch124 -p1 -b .localecrash
%patch125 -p1 -b .fileselectorfallback
%patch126 -p1 -b .defaultcolor
%patch128 -p1 -b .argb
%patch129 -p1 -b .ahiguchi
%patch130 -p1 -b .ppc64

%build
%def_disable static
%add_optflags -L/%_lib -lm
export ac_cv_prog_INDENT=indent
libtoolize --copy --force
automake --foreign --include-deps --add-missing --copy
autoconf
autoheader
%configure %{subst_enable static} --with-xinput=xfree
%make_build

%install
%makeinstall

cd %buildroot%_sysconfdir/gtk
mv gtkrc.uk gtkrc.uk_UA.koi8u
ln -s gtkrc.ru_RU.cp1251 gtkrc.uk_UA.cp1251
ln -s gtkrc.uk_UA.koi8u gtkrc.ru_UA.koi8u
subst -p 's/14/12/g' gtkrc.uk_UA.koi8u
tar xf %SOURCE1
cd -

%define pkgdocdir %_docdir/%name-%version
mkdir -p %buildroot%pkgdocdir/devel
install -p -m644 AUTHORS NEWS README TODO %buildroot%pkgdocdir
cp -a docs/{*.txt,html,text} %buildroot%pkgdocdir/devel

%find_lang %name

# Some language names in files (like .pl) made them look like Perl scripts.
%add_findreq_skiplist %_sysconfdir/gtk/*
%add_findprov_skiplist %_sysconfdir/gtk/*

%files -f %name.lang
%dir %pkgdocdir
%pkgdocdir/AUTHORS
%pkgdocdir/NEWS
%pkgdocdir/README
%pkgdocdir/TODO
%_libdir/lib*.so.*
%_datadir/themes/Default
%config(noreplace) %_sysconfdir/gtk/

%files devel
%dir %pkgdocdir
%pkgdocdir/devel/
%_libdir/lib*.so
%_libdir/pkgconfig/*
#_libdir/lib*.la
%_man1dir/*.*
%_infodir/*.info*
%_includedir/*
%_datadir/aclocal/*
%_bindir/*

%if_enabled static
%files devel-static
%_libdir/lib*.a
%endif

%changelog
