%define ver_major 3.32
%define origname gtkhtml
%def_disable static
%def_disable gtk_doc
%def_disable gtk3
%if_enabled gtk3
%define api_ver 4.0
%else
%define api_ver 3.14
%endif

Name: gtkhtml3
Version: %ver_major.2
Release: alt4

Summary: GtkHTML is a HTML rendering/editing library
License: GPL
Group: Graphical desktop/GNOME
Url: http://projects.gnome.org/evolution/

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: ftp://ftp.gnome.org/pub/gnome/sources/%origname/%ver_major/%origname-%version.tar.bz2
Source1: lib%{name}-%ver_major.map
Patch1: %name-%ver_major-alt-symver.patch
Patch2: %name-3.32.2-alt-deprecation.patch
Patch3: %name-3.32.2-alt3-deprecation.patch

# from configure.in
%define gtk_ver 2.21.6
%define gtk3_ver 2.90.4
%define gail_ver 1.1.0
%define gnome_icon_ver 2.22.0
%define libsoup_ver 2.31.6

BuildPreReq: gnome-common

BuildPreReq: intltool >= 0.36.3
%if_enabled gtk3
BuildPreReq: libgtk+3-devel >= %gtk3_ver
BuildPreReq: libgail3-devel
%else
BuildPreReq: libgtk+2-devel >= %gtk_ver
BuildPreReq: libgail-devel >= %gail_ver
%endif
BuildPreReq: gnome-icon-theme >= %gnome_icon_ver
BuildPreReq: libsoup-devel >= %libsoup_ver
BuildPreReq: iso-codes-devel libenchant-devel >= 1.1.7
BuildPreReq: libGConf-devel

%description
GtkHTML is a HTML rendering/editing library. GtkHTML is not designed to
be the ultimate HTML browser/editor: instead, it is designed to be
easily embedded into applications that require lightweight HTML
functionality.

GtkHTML was originally based on KDE's KHTMLW widget, but is now
developed independently of it. The most important difference between
KHTMLW and GtkHTML, besides being GTK-based, is that GtkHTML is also an
editor. Thanks to the Bonobo editor component that comes with the
library, it's extremely simple to add HTML editing to an existing
application.

%package -n lib%name
Summary: Libraries for GtkHTML
Group: System/Libraries

%description -n lib%name
GtkHTML is a HTML rendering/editing library. GtkHTML is not designed to
be the ultimate HTML browser/editor: instead, it is designed to be
easily embedded into applications that require lightweight HTML
functionality.

This package contains libraries used by GtkHTML.

%package -n lib%name-devel
Provides: lib%name-devel
Summary: Development libraries, header files and utilities for GtkHTML
Group: Development/GNOME and GTK+
Requires: lib%name = %version-%release

%description -n lib%name-devel
GtkHTML is a HTML rendering/editing library. GtkHTML is not designed to
be the ultimate HTML browser/editor: instead, it is designed to be
easily embedded into applications that require lightweight HTML
functionality.

This package contains the files necessary to develop applications with GtkHTML.

%package -n lib%name-devel-static
Provides: lib%name-devel-static
Summary: Static libraries for GtkHTML
Group: Development/GNOME and GTK+

%description -n lib%name-devel-static
GtkHTML is a HTML rendering/editing library. GtkHTML is not designed to
be the ultimate HTML browser/editor: instead, it is designed to be
easily embedded into applications that require lightweight HTML
functionality.

This package contains the files necessary to develop applications
statically linked with GtkHTML.

%prep
%setup -q -n %origname-%version
install -p -m644 %SOURCE1 gtkhtml/libgtkhtml.map
%if_disabled gtk3
%patch1
%endif

%patch2
%patch3

%build
%autoreconf
export LDFLAGS="$LDFLAGS -lm"
%configure \
    %{subst_enable static} \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    %{subst_enable gtk3}

%make_build

%install
%make_install DESTDIR=%buildroot install

%find_lang %origname-%api_ver

%files -n lib%name -f %origname-%api_ver.lang
%_libdir/*.so.*
%_datadir/%origname-%api_ver
%doc AUTHORS ChangeLog NEWS README TODO

%files -n lib%name-devel
%_bindir/gtkhtml-editor-test
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%_libdir/%origname/*.a
%endif

%changelog
