# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/curl-config /usr/bin/glib-gettextize libgtk+2-devel
# END SourceDeps(oneline)
%define fedora 21
Name:		gtorrentviewer
Version:	0.2b
Release:	alt4_32
Summary:	A GTK2-based viewer and editor for BitTorrent meta files
Group:		Networking/WWW
License:	GPL+
URL:		http://gtorrentviewer.sourceforge.net/
Source0:	http://downloads.sf.net/gtorrentviewer/GTorrentViewer-%{version}.tar.gz
Patch0:		gtorrentviewer-0.2b-desktop.patch
Patch1:		gtorrentviewer-0.2b-dso-linking.patch
Patch2:		GTorrentViewer-0.2b-tracker-details-refresh.patch
Patch3:		gtorrentviewer-0.2b-trackerdetails.patch
Patch4:		GTorrentViewer-0.2b-curl-types.patch
Patch5:		GTorrentViewer-0.2b-format.patch
Patch6:		GTorrentViewer-0.2b-missing-tracker.patch
BuildRequires:	curl-devel gtk2-devel >= 2.4 desktop-file-utils gettext intltool

Requires(post):	  desktop-file-utils
Requires(postun): desktop-file-utils
Source44: import.info

%description
GTorrentViewer gives you the ability to see and modify all the possible
information from .torrent files without having to start downloading, and
the ability to see in real time the current number of seeds and peers on
the torrent, so you will always know the status before starting the
download.

%prep
%setup -q -n GTorrentViewer-%{version}

# Let drag and drop work with URIs as well as files (#206262)
# Also drop ".png" suffix from icon filename, as per Icon Theme spec
%patch0

# mainwindow.c requires ceil() from libm (#564928)
%patch1 -p1

# Fix crash due to use of uninitialized GValue (#542502, #572806)
%patch2 -p1

# Improve tracker support (#674726)
%patch3 -p1

# <curl/types.h> went away in curl 7.22.0
%patch4 -p1

# Add missing format strings in g_warning() invocations
%patch5

# Avoid segfault when dealing with torrent that has no tracker (#1178062)
%patch6

# curl/types.h are no more; was true for  0.2b-22.
sed -i 's,#include <curl/types.h>,,' src/main.c

%build
%configure
make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot} INSTALL="install -p"
rm -f %{buildroot}%{_datadir}/GTorrentViewer/README
desktop-file-install \
%if 0%{?fedora} < 19 && 0%{?rhel} < 4
	--vendor fedora \
%else
	--vendor "" \
%endif
	--add-category X-Fedora \
	--delete-original \
	--dir %{buildroot}%{_datadir}/applications \
	%{buildroot}%{_datadir}/applications/gtorrentviewer.desktop

desktop-file-install --dir %buildroot%_desktopdir \
        --add-category=FileTransfer \
        --add-category=P2P \
        %buildroot%_desktopdir/gtorrentviewer.desktop

%files
%if 0%{?_licensedir:1}
%doc COPYING
%else
%doc COPYING
%endif
%doc AUTHORS ChangeLog README
%{_bindir}/gtorrentviewer
%{_datadir}/GTorrentViewer
%if 0%{?fedora} < 19 && 0%{?rhel} < 4
%{_datadir}/applications/fedora-gtorrentviewer.desktop
%else
%{_datadir}/applications/gtorrentviewer.desktop
%endif
%{_datadir}/pixmaps/gtorrentviewer.png
%{_datadir}/pixmaps/gtorrentviewer.xpm
%{_mandir}/man1/gtorrentviewer.1*

%changelog
