BuildRequires: desktop-file-utils
%define oname gXNeur

Name: gxneur
Version: 0.17.0
Release: alt4

Summary: GTK frontend for X Neural Switcher
License: GPL
Group: Office

Url: http://xneur.ru/
Source: %{name}_%version.orig.tar.gz
Source1: %name.png

# Automatically added by buildreq on Sun May 22 2011
# optimized out: fontconfig fontconfig-devel glib2-devel libX11-devel libaspell-devel libatk-devel libcairo-devel libdbus-glib libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgtk+2-devel libpango-devel libpcre-devel pkg-config xorg-kbproto-devel xorg-xproto-devel
BuildRequires: libGConf libGConf-devel libglade-devel libxneur-devel

Requires: xneur >= %version

%define flagsdir %_iconsdir/flags

%description
Xneur is program like Punto Switcher, but has other
functionality and features for configuring.

%package -n icon-flags
Summary: Custom country flags for language layout indicators
Group: Graphics
BuildArch: noarch

%description -n icon-flags
Custom country flags for language layout indicators
(from gxneur sources).

%prep
%setup

%build
# autoreconf breaks on ALT 4.1
%configure
%make_build

%install
%makeinstall_std
rm -rf %buildroot%prefix/doc/
%find_lang %name

install -Dm 0644 %SOURCE1 %buildroot%_pixmapsdir/%name.png
mkdir -p %buildroot%_desktopdir/
cat > %buildroot%_desktopdir/%name.desktop << EOF
[Desktop Entry]
Encoding=UTF-8
Name=gXNeur
GenericName=Keyboard Layout Switcher
GenericName[ru]=Переключатель раскладки клавиатуры
Type=Application
Exec=gxneur
Icon=gxneur
Categories=Utility;GTK;GNOME;Accessibility
Comment=Automatic keyboard layout switcher
Comment[ru]=Автоматический переключатель раскладки клавиатуры
StartupNotify=false
Terminal=false
EOF

# use 24x24 as these won't require scalingh
#mkdir -p %buildroot%flagsdir
#cp -al pixmaps/??.png %buildroot%flagsdir/
for src in %buildroot%_iconsdir/hicolor/24x24/apps/gxneur-??.png; do
	install -pDm644 "$src" %buildroot%flagsdir/"${src##*-}"
done

%files -f %name.lang
%doc AUTHORS ChangeLog NEWS README TODO
%_bindir/gxneur
%_datadir/%name/
%_man1dir/*
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/*
%_iconsdir/hicolor/scalable/apps/%name.*
%_pixmapsdir/%name.png

%files -n icon-flags
%flagsdir/??.png

%changelog
