Name: gzip
Version: 1.8.0.20.82c6
Release: alt1

Summary: The GNU data compression program
License: GPLv3+
Group: Archiving/Compression
Url: http://www.gnu.org/software/gzip/

%define srcname %name-%version-%release
Source0: %srcname.tar

BuildRequires: gnulib >= 0.1.1209.24b32, makeinfo

# for test suite
%{?!_without_check:%{?!_disable_check:BuildRequires: less}}

%package utils
Summary: Utilities for handy use of the GNU gzip
Group: Archiving/Compression
BuildArch: noarch
Requires: %name = %version-%release, mktemp >= 1:1.3.1
Provides: %name-devel = %version-%release
Obsoletes: %name-devel
Provides: bzip2-utils = 0:1.0.3-alt5
Obsoletes: bzip2-utils
Conflicts: lzma-utils < 0:4.32.9

%description
This package contains the popular GNU gzip data compression
program and its associated scripts to manage compressed files.

%description utils
This package contains additional utilities for the popular
GNU gzip, bzip2, lzma and xz data compression programs.

%prep
%setup -n %srcname

# Use fresh bootstrap from gnulib
install -pm755 %_datadir/gnulib/build-aux/bootstrap .

# Build scripts expect to find the gzip version in this file.
echo -n %version > .tarball-version

%build
%define _optlevel 3
%add_optflags -DGNU_STANDARD=0 %optflags_notraceback
./bootstrap --skip-po --gnulib-srcdir=%_datadir/gnulib

# Unset the variable gl_printf_safe to indicate that we do not need
# a safe handling of non-IEEE-754 'long double' values.
sed -i 's/gl_printf_safe=yes/gl_printf_safe=/' m4/gnulib-comp.m4 configure

%configure --bindir=/bin --disable-silent-rules
%make_build
ln -snf zdiff zcmp
cp -p gzip.1 gzip.doc

%install
mkdir -p %buildroot%_bindir
%makeinstall_std bindir=/bin

# uncompress is a part of ncompress package
rm %buildroot/bin/uncompress

for i in zcmp zegrep zforce znew gzexe zdiff zfgrep zgrep; do
	mv %buildroot/bin/$i %buildroot%_bindir/
done

# Replace wrappers with symlinks.
ln -sf gzip %buildroot/bin/gunzip
ln -sf gzip %buildroot/bin/zcat
ln -sf zdiff %buildroot%_bindir/zcmp
ln -sf zgrep %buildroot%_bindir/zegrep
ln -sf zgrep %buildroot%_bindir/zfgrep

# Add compatibility symlinks.
for i in gzip gunzip zcat; do
	ln -s ../../bin/gzip %buildroot%_bindir/$i
done

# Additional utilities.
for c in bz lz lz4 lzi lzo xz zstd; do
	ln -s zdiff %buildroot%_bindir/${c}cmp
	ln -s zdiff %buildroot%_bindir/${c}diff
	ln -s zgrep %buildroot%_bindir/${c}grep
	ln -s zgrep %buildroot%_bindir/${c}egrep
	ln -s zgrep %buildroot%_bindir/${c}fgrep
done
install -pm755 zme.sh %buildroot%_bindir/zme
ln -s zme %buildroot%_bindir/bzme

# Additional manpages.
echo '.so man1/zgrep.1' >%buildroot%_man1dir/zegrep.1
echo '.so man1/zgrep.1' >%buildroot%_man1dir/zfgrep.1
for c in bz lz lz4 lzi lzo xz zstd; do
	echo '.so man1/zdiff.1' >%buildroot%_man1dir/${c}cmp.1
	echo '.so man1/zdiff.1' >%buildroot%_man1dir/${c}diff.1
	echo '.so man1/zgrep.1' >%buildroot%_man1dir/${c}grep.1
	echo '.so man1/zgrep.1' >%buildroot%_man1dir/${c}egrep.1
	echo '.so man1/zgrep.1' >%buildroot%_man1dir/${c}fgrep.1
done
install -pm755 zme.1 %buildroot%_man1dir/
ln -s zme.1 %buildroot%_man1dir/bzme.1

# Our zless and zmore live in less package.
rm %buildroot{/bin/z{less,more},%_man1dir/z{less,more}.1}

%check
%make_build -k check

%files
/bin/*
%_bindir/g*zip
%_bindir/zcat
%_man1dir/g*zip.*
%_man1dir/zcat.*
%_infodir/*.info*
%doc AUTHORS NEWS README THANKS TODO

%files utils
%_bindir/*
%_man1dir/*
%exclude %_bindir/g*zip
%exclude %_bindir/zcat
%exclude %_man1dir/g*zip.*
%exclude %_man1dir/zcat.*

%changelog
