%define hdf5dir %_libdir/hdf5-seq

%def_with python3

Name: h5py
Version: 2.5.0
Release: alt2.git20150720.1
Summary: Python interface to the Hierarchical Data Format library, version 5
License: MIT
Group: Development/Python
Url: http://www.h5py.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/h5py/h5py.git
Source: %name-%version.tar.gz

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel libnumpy-devel libhdf5-devel
BuildPreReq: libsz2-devel python-module-Cython python-module-Pyrex
BuildPreReq: python-module-sphinx-devel python-module-Pygments
BuildPreReq: python-module-setuptools-tests python-module-six
BuildPreReq: python-module-pkgconfig
#BuildPreReq: texlive-latex-recommended
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel libnumpy-py3-devel
BuildPreReq: python3-module-setuptools-tests
BuildPreReq: python3-module-Cython python3-module-six
BuildPreReq: python3-module-pkgconfig
%endif

%description
HDF5 for Python (h5py) is a general-purpose Python interface to the
Hierarchical Data Format library, version 5. HDF5 is a versatile, mature
scientific software library designed for the fast, flexible storage of
enormous amounts of data.

From a Python programmer's perspective, HDF5 provides a robust way to
store data, organized by name in a tree-like fashion. You can create
datasets (arrays on disk) hundreds of gigabytes in size, and perform
random-access I/O on desired sections. Datasets are organized in a
filesystem-like hierarchy using containers called "groups", and accessed
using the tradional POSIX /path/to/resource syntax.

H5py provides a simple, robust read/write interface to HDF5 data from
Python. Existing Python and Numpy concepts are used for the interface;
for example, datasets on disk are represented by a proxy class that
supports slicing, and has dtype and shape attributes. HDF5 groups are
presented using a dictionary metaphor, indexed by name.

%package -n python-module-%name
Summary: Python interface to the Hierarchical Data Format library, version 5
Group: Development/Python
%setup_python_module %name
%py_requires multiprocessing
%py_requires h5py.tests

%description -n python-module-%name
HDF5 for Python (h5py) is a general-purpose Python interface to the
Hierarchical Data Format library, version 5. HDF5 is a versatile, mature
scientific software library designed for the fast, flexible storage of
enormous amounts of data.

From a Python programmer's perspective, HDF5 provides a robust way to
store data, organized by name in a tree-like fashion. You can create
datasets (arrays on disk) hundreds of gigabytes in size, and perform
random-access I/O on desired sections. Datasets are organized in a
filesystem-like hierarchy using containers called "groups", and accessed
using the tradional POSIX /path/to/resource syntax.

H5py provides a simple, robust read/write interface to HDF5 data from
Python. Existing Python and Numpy concepts are used for the interface;
for example, datasets on disk are represented by a proxy class that
supports slicing, and has dtype and shape attributes. HDF5 groups are
presented using a dictionary metaphor, indexed by name.

%package -n python3-module-%name
Summary: Python interface to the Hierarchical Data Format library, version 5
Group: Development/Python3
%py3_requires h5py.tests

%description -n python3-module-%name
HDF5 for Python (h5py) is a general-purpose Python interface to the
Hierarchical Data Format library, version 5. HDF5 is a versatile, mature
scientific software library designed for the fast, flexible storage of
enormous amounts of data.

From a Python programmer's perspective, HDF5 provides a robust way to
store data, organized by name in a tree-like fashion. You can create
datasets (arrays on disk) hundreds of gigabytes in size, and perform
random-access I/O on desired sections. Datasets are organized in a
filesystem-like hierarchy using containers called "groups", and accessed
using the tradional POSIX /path/to/resource syntax.

H5py provides a simple, robust read/write interface to HDF5 data from
Python. Existing Python and Numpy concepts are used for the interface;
for example, datasets on disk are represented by a proxy class that
supports slicing, and has dtype and shape attributes. HDF5 groups are
presented using a dictionary metaphor, indexed by name.

%package -n python-module-%name-doc
Summary: Documentation for Python interface to the HDF5
Group: Development/Documentation
BuildArch: noarch

%description -n python-module-%name-doc
HDF5 for Python (h5py) is a general-purpose Python interface to the
Hierarchical Data Format library, version 5. HDF5 is a versatile, mature
scientific software library designed for the fast, flexible storage of
enormous amounts of data.

From a Python programmer's perspective, HDF5 provides a robust way to
store data, organized by name in a tree-like fashion. You can create
datasets (arrays on disk) hundreds of gigabytes in size, and perform
random-access I/O on desired sections. Datasets are organized in a
filesystem-like hierarchy using containers called "groups", and accessed
using the tradional POSIX /path/to/resource syntax.

H5py provides a simple, robust read/write interface to HDF5 data from
Python. Existing Python and Numpy concepts are used for the interface;
for example, datasets on disk are represented by a proxy class that
supports slicing, and has dtype and shape attributes. HDF5 groups are
presented using a dictionary metaphor, indexed by name.

This package contains development documentation for H5PY.

%package -n python-module-%name-pickles
Summary: Pickles for Python interface to the HDF5
Group: Development/Python

%description -n python-module-%name-pickles
HDF5 for Python (h5py) is a general-purpose Python interface to the
Hierarchical Data Format library, version 5. HDF5 is a versatile, mature
scientific software library designed for the fast, flexible storage of
enormous amounts of data.

From a Python programmer's perspective, HDF5 provides a robust way to
store data, organized by name in a tree-like fashion. You can create
datasets (arrays on disk) hundreds of gigabytes in size, and perform
random-access I/O on desired sections. Datasets are organized in a
filesystem-like hierarchy using containers called "groups", and accessed
using the tradional POSIX /path/to/resource syntax.

H5py provides a simple, robust read/write interface to HDF5 data from
Python. Existing Python and Numpy concepts are used for the interface;
for example, datasets on disk are represented by a proxy class that
supports slicing, and has dtype and shape attributes. HDF5 groups are
presented using a dictionary metaphor, indexed by name.

This package contains pickles for H5PY.

%package -n python-module-%name-tests
Summary: Tests for Python interface to the HDF5
Group: Development/Python
Requires: python-module-%name = %version-%release

%description -n python-module-%name-tests
HDF5 for Python (h5py) is a general-purpose Python interface to the
Hierarchical Data Format library, version 5. HDF5 is a versatile, mature
scientific software library designed for the fast, flexible storage of
enormous amounts of data.

From a Python programmer's perspective, HDF5 provides a robust way to
store data, organized by name in a tree-like fashion. You can create
datasets (arrays on disk) hundreds of gigabytes in size, and perform
random-access I/O on desired sections. Datasets are organized in a
filesystem-like hierarchy using containers called "groups", and accessed
using the tradional POSIX /path/to/resource syntax.

H5py provides a simple, robust read/write interface to HDF5 data from
Python. Existing Python and Numpy concepts are used for the interface;
for example, datasets on disk are represented by a proxy class that
supports slicing, and has dtype and shape attributes. HDF5 groups are
presented using a dictionary metaphor, indexed by name.

This package contains tests for H5PY.

%package -n python3-module-%name-tests
Summary: Tests for Python interface to the HDF5
Group: Development/Python3
Requires: python3-module-%name = %version-%release

%description -n python3-module-%name-tests
HDF5 for Python (h5py) is a general-purpose Python interface to the
Hierarchical Data Format library, version 5. HDF5 is a versatile, mature
scientific software library designed for the fast, flexible storage of
enormous amounts of data.

From a Python programmer's perspective, HDF5 provides a robust way to
store data, organized by name in a tree-like fashion. You can create
datasets (arrays on disk) hundreds of gigabytes in size, and perform
random-access I/O on desired sections. Datasets are organized in a
filesystem-like hierarchy using containers called "groups", and accessed
using the tradional POSIX /path/to/resource syntax.

H5py provides a simple, robust read/write interface to HDF5 data from
Python. Existing Python and Numpy concepts are used for the interface;
for example, datasets on disk are represented by a proxy class that
supports slicing, and has dtype and shape attributes. HDF5 groups are
presented using a dictionary metaphor, indexed by name.

This package contains tests for H5PY.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

sed -i 's|@PYVER@|%_python_version|g' docs/Makefile

%prepare_sphinx .
ln -s ../objects.inv docs/
ln -s ../objects.inv docs_api/

%build
%add_optflags -fno-strict-aliasing
#python setup.py cython
python setup.py configure --hdf5=%hdf5dir
python api_gen.py
%python_build_debug

%if_with python3
pushd ../python3
python3 setup.py configure --hdf5=%hdf5dir
python3 api_gen.py
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

export PYTHONPATH=%buildroot%python_sitelibdir
pushd docs
%make html
%make pickle
popd
%make -C docs_api html

install -d %buildroot%python_sitelibdir/%name/examples
install -p -m644 examples/* %buildroot%python_sitelibdir/%name/examples
touch %buildroot%python_sitelibdir/%name/examples/__init__.py

install -d %buildroot%_docdir/%name
cp -fR docs/_build/html %buildroot%_docdir/%name/html
cp -fR docs_api/_build/html %buildroot%_docdir/%name/api
cp -fR lzf %buildroot%_docdir/%name/
#install -m644 docs/build/latex/*.pdf %buildroot%_docdir/%name/pdf

# pickles

cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%name/

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files -n python-module-%name
%doc licenses *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/%name/pickle
%exclude %python_sitelibdir/%name/examples
%exclude %python_sitelibdir/*/tests

%files -n python-module-%name-doc
%_docdir/%name

%files -n python-module-%name-tests
%python_sitelibdir/*/tests
%python_sitelibdir/%name/examples

%files -n python-module-%name-pickles
%dir %python_sitelibdir/%name
%python_sitelibdir/%name/pickle

%if_with python3
%files -n python3-module-%name
%doc licenses *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%files -n python3-module-%name-tests
%python3_sitelibdir/*/tests
%endif

%changelog
