Name: hasher-priv
Version: 1.5.2
Release: alt1

Summary: A privileged helper for the hasher project
License: GPLv2+
Group: Development/Other

Source: %name-%version.tar

%define _libexecdir %_prefix/libexec
%define helperdir %_libexecdir/%name
%define configdir %_sysconfdir/%name

Provides: %helperdir
PreReq: coreutils, shadow-utils, glibc-utils
Obsoletes: pkg-build-priv

# Due to libexec hell.
Conflicts: hasher < 0:1.0.9-alt0.M24.1

BuildPreReq: help2man, sisyphus_check >= 0:0.7.11

%description
This package provides helpers for executing privileged operations
required by hasher utilities.

%prep
%setup

%build
%make_build CC="%__cc" CFLAGS="%optflags" libexecdir="%_libexecdir"

%install
%makeinstall

%pre
if getent group pkg-build > /dev/null; then
	groupmod -n hashman pkg-build
fi
if [ -d %_sysconfdir/pkg-build-priv -a ! -d %configdir ]; then
	mv %_sysconfdir/pkg-build-priv %configdir
fi
groupadd -r -f hashman

%files
%_sbindir/hasher-useradd
%_mandir/man?/*
# config
%attr(750,root,hashman) %dir %configdir
%attr(750,root,hashman) %dir %configdir/user.d
%attr(640,root,hashman) %config(noreplace) %configdir/fstab
%attr(640,root,hashman) %config(noreplace) %configdir/system
# helpers
%attr(750,root,hashman) %dir %helperdir
%attr(6710,root,hashman) %helperdir/%name
%attr(755,root,root) %helperdir/*.sh

%doc DESIGN

%changelog
