Group: Development/Java
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# %%name or %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name hibernate-jpa-2.1-api
%define version 1.0.0
%global namedreltag .Draft-16
%global namedversion %{version}%{?namedreltag}
%global oname hibernate-jpa-api
%global apiversion 2.1
Name:          hibernate-jpa-2.1-api
Version:       1.0.0
Release:       alt1_0.7.Draft.16jpp8
Summary:       Java Persistence 2.1 (JSR 338) API
License:       EPL and BSD
URL:           http://www.hibernate.org/
Source0:       https://github.com/hibernate/hibernate-jpa-api/archive/2.1-%{namedversion}.tar.gz
Source1:       http://repo1.maven.org/maven2/org/hibernate/javax/persistence/%{name}/%{namedversion}/%{name}-%{namedversion}.pom
# fix mvn build, this project uses the default Gradle to build
# sets various mvn plugins properties
Patch0:        %{oname}-2.1-1.0.0.Draft-16-pom.patch

BuildRequires: maven-local
BuildRequires: maven-plugin-bundle

BuildArch:     noarch
Source44: import.info

%description
Hibernate definition of the Java Persistence 2.1 (JSR 338) API.

%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.

%prep
%setup -q -n %{oname}-%{apiversion}-%{namedversion}
find . -name "*.jar" -delete

cp -p %{SOURCE1} pom.xml
%patch0 -p0

for s in src/main/java/javax/persistence/MapsId.java \
  src/main/java/javax/persistence/NamedStoredProcedureQuery.java \
  src/main/java/javax/persistence/EntityManager.java \
  src/main/java/javax/persistence/ForeignKey.java; do
 native2ascii -encoding UTF8 ${s} ${s}
done

# Fixing wrong-file-end-of-line-encoding
sed -i 's/\r//' src/main/javadoc/jdstyle.css

%mvn_file :%{name} %{name}

%build

%mvn_build

%install
%mvn_install

%files -f .mfiles
%doc README.md
%doc license.txt

%files javadoc -f .mfiles-javadoc
%doc license.txt

%changelog
