Epoch: 1
Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-java
# END SourceDeps(oneline)
BuildRequires: docbook-dtds
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
%define fedora 23
# %%name or %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name hibernate3
%define version 3.6.10
%global namedreltag .Final
%global namedversion %{version}%{?namedreltag}
%global majorversion 3
%global oname hibernate-orm

Name:    hibernate3
Version: 3.6.10
Release: alt3_17jpp8
Summary: Relational persistence and query service
License: LGPLv2+
URL:     http://www.hibernate.org/
# git clone git://github.com/hibernate/hibernate-orm
# cd hibernate-orm/ && git archive --format=tar --prefix=hibernate-orm-3.6.10.Final/ 3.6.10.Final | xz > hibernate-3.6.10.Final.tar.xz
Source0: hibernate-orm-3.6.10.Final.tar.xz
Source1: hibernate3-depmap
Patch0:  hibernate-orm-fix-cglib-gid.patch
Patch1:  hibernate-orm-fix-jacc-gid-aid.patch
Patch2:  hibernate-orm-fix-ant-gid.patch
Patch3:  hibernate-orm-infinispan-5-support.patch
Patch4:  hibernate-orm-cglib-3.1.patch

BuildArch: noarch

BuildRequires: jpackage-utils
BuildRequires: maven-local >= 0.7.2
BuildRequires: maven-local
BuildRequires: maven-release-plugin
BuildRequires: maven-enforcer-plugin
BuildRequires: maven-injection-plugin
BuildRequires: antlr-maven-plugin
BuildRequires: geronimo-validation
BuildRequires: geronimo-jta
BuildRequires: hibernate-validator
BuildRequires: cglib
BuildRequires: jboss-jacc-1.4-api
BuildRequires: c3p0
BuildRequires: proxool
BuildRequires: hibernate-commons-annotations
BuildRequires: jboss-servlet-3.0-api
BuildRequires: ehcache-core
# jbosscache was retired
# BuildRequires: jbosscache-core
# BuildRequires: jbosscache-common-parent
# H3 dont support infinispan > 5.3.0
# BuildRequires: infinispan
BuildRequires: rhq-plugin-annotations
BuildRequires: h2
%if %{fedora} > 19
BuildRequires: mvn(hsqldb:hsqldb:1)
%else
BuildRequires: mvn(hsqldb:hsqldb)
%endif
BuildRequires: mvn(org.slf4j:slf4j-log4j12)
BuildRequires: glassfish-jaxb
BuildRequires: shrinkwrap
BuildRequires: jboss-transaction-1.1-api

Obsoletes: %{name}-infinispan < %{version}-%{release}
Obsoletes: %{name}-jbosscache < %{version}-%{release}
Source44: import.info

%description
Hibernate is a powerful, ultra-high performance
object/relational persistence and query service
for Java.

%package javadoc
Group: Development/Java
Summary: API docs for %{name}
BuildArch: noarch

%description javadoc
API documentation for %{name}.

%package entitymanager
Group: Development/Java
Summary: Hibernate Entity Manager

%description entitymanager
%{summary}.

%package envers
Group: Development/Java
Summary: Hibernate support for entity auditing

%description envers
%{summary}.

%package c3p0
Group: Development/Java
Summary: C3P0-based implementation of Hibernate ConnectionProvider

%description c3p0
%{summary}.

%package proxool
Group: Development/Java
Summary: Proxool-based implementation of Hibernate ConnectionProvder

%description proxool
%{summary}.

%package ehcache
Group: Development/Java
Summary: Integration of Hibernate with Ehcache

%description ehcache
%{summary}.

%package testing
Group: Development/Java
Summary: Hibernate JUnit test utilities

%description testing
%{summary}.

%prep
%setup -q -n %{oname}-%{namedversion}
%patch0 -p1
%patch1 -p1
%patch2 -p1
#%%patch3 -p1
%patch4 -p1

%pom_remove_plugin org.jboss.maven.plugins:maven-jdocbook-plugin hibernate-parent
%pom_remove_plugin org.jboss.maven.plugins:maven-jdocbook-style-plugin hibernate-parent
%pom_remove_plugin :gmaven-plugin hibernate-parent
%pom_disable_module hibernate-testsuite
%pom_disable_module hibernate-oscache
%pom_disable_module hibernate-swarmcache
%pom_disable_module hibernate-jdbc3-testing
%pom_disable_module hibernate-jdbc4-testing

%pom_disable_module hibernate-infinispan
%pom_disable_module hibernate-jbosscache

# Remove test deps infinispan jbosscache
for m in envers entitymanager ehcache; do
%pom_xpath_remove "pom:dependencies/pom:dependency[pom:scope = 'test']" hibernate-${m}/pom.xml
done

# We don't need it
%pom_xpath_remove pom:build/pom:extensions hibernate-parent/pom.xml

# disable hibernate-tools support
%pom_remove_dep org.hibernate:hibernate-tools hibernate-envers
%pom_remove_dep ant:ant hibernate-envers
rm -r hibernate-envers/src/main/java/org/hibernate/tool/ant/*.java \
  hibernate-envers/src/main/java/org/hibernate/envers/ant/*.java

# Make hibernate-testing back a test dependency...
#sed -i "s|<!-- <scope>test</scope> TODO fix this -->|<scope>test</scope>|" hibernate-infinispan/pom.xml

# Fix the c3p0 gid
%pom_xpath_set "pom:project/pom:dependencies/pom:dependency[pom:artifactId = 'c3p0' ]/pom:groupId" com.mchange  hibernate-c3p0

# Fix the hibernate-commons-annotations gid
for f in hibernate-core hibernate-envers;do
%pom_xpath_set "pom:project/pom:dependencies/pom:dependency[pom:artifactId = 'hibernate-commons-annotations' ]/pom:groupId" org.hibernate.common  ${f}
done

for f in hibernate-core hibernate-entitymanager hibernate-parent;do
sed -i "s|<groupId>javax.validation|<groupId>org.apache.geronimo.specs|" ${f}/pom.xml
sed -i "s|<artifactId>validation-api|<artifactId>geronimo-validation_1.0_spec|" ${f}/pom.xml
done

sed -i "s|<groupId>javax.transaction|<groupId>org.jboss.spec.javax.transaction|" hibernate-core/pom.xml
sed -i "s|<artifactId>jta|<artifactId>jboss-transaction-api_1.1_spec|" hibernate-core/pom.xml
sed -i "s|<version>1.1</version>|<version>1.0.1.Final</version>|" hibernate-core/pom.xml

%pom_xpath_set "pom:project/pom:dependencyManagement/pom:dependencies/pom:dependency[pom:artifactId = 'hibernate-commons-annotations' ]/pom:groupId" org.hibernate.common  hibernate-parent

sed -i "s,59 Temple Place,51 Franklin Street,;s,Suite 330,Fifth Floor,;s,02111-1307,02110-1301," lgpl.txt

%mvn_compat_version : %{majorversion} %{namedversion}
%mvn_package ":hibernate-parent" %{name}
%mvn_package ":hibernate-core" %{name}
%mvn_package ":hibernate" __noinstall

%build

# Currently 4 tests fail with this error:
# "Unable to get the default Bean Validation factory"
export jdk16_home=/usr
export LANG=en_US.UTF-8
%mvn_build -s -f -- -DdisableDistribution=true

%install
%mvn_install

%files -f .mfiles-%{name}
%doc changelog.txt
%dir %{_javadir}/%{name}
%doc lgpl.txt

%files javadoc -f .mfiles-javadoc
%doc lgpl.txt

%files entitymanager -f .mfiles-hibernate-entitymanager
%doc lgpl.txt

%files envers -f .mfiles-hibernate-envers
%doc lgpl.txt

%files c3p0 -f .mfiles-hibernate-c3p0
%doc lgpl.txt

%files ehcache -f .mfiles-hibernate-ehcache
%doc lgpl.txt

%files proxool -f .mfiles-hibernate-proxool
%doc lgpl.txt

%files testing -f .mfiles-hibernate-testing
%doc lgpl.txt

%changelog
