%define sover 0.11

Name: hiredis
Version: 0.11.0
Release: alt1.git20140529
Summary: The official C client for Redis

Group: System/Libraries
License: BSD
Url: https://github.com/redis/hiredis

# https://github.com/redis/hiredis.git
Source: %name-%version.tar

BuildRequires: gcc-c++ libevent-devel libev-devel

%description
Hiredis is a minimalistic C client library for the Redis database.

%package -n lib%name%sover
Summary: The official C client for Redis
License: BSD
Group: System/Libraries

Provides: hiredis = %version-%release
Obsoletes: hiredis

%description -n lib%name%sover
Hiredis is a minimalistic C client library for the Redis database.

%package -n lib%name-devel
Summary: Header files and libraries for hiredis C development
Group: Development/C
Requires: lib%name%sover = %version-%release

Provides: hiredis-devel = %version-%release
Obsoletes: hiredis-devel

%description -n lib%name-devel
The %name-devel package contains the header files and
ibraries to develop applications using a Redis database.

%prep
%setup

%build
%make_build
%make examples
%make hiredis-test

%install
%ifarch x86_64
LIB_SUFFIX=64
%endif
%make install PREFIX=%buildroot%_prefix  LIBRARY_PATH=%_lib \
	LIB_SUFFIX=$LIB_SUFFIX

mkdir -p %buildroot%_bindir/
cp examples/hiredis-example* %buildroot%_bindir/
cp hiredis-test %buildroot%_bindir/

%files -n lib%name%sover
%doc COPYING CHANGELOG.md
%_bindir/hiredis-example*
%_bindir/hiredis-test
%_libdir/*.so.*

%files -n lib%name-devel
%doc README.md
%_includedir/%name
%_libdir/*.so

%changelog
