%def_enable openvz
%def_enable unicode
%def_enable taskstats
%def_enable oom

Name: htop
Version: 2.0.1
Release: alt1

Summary: Interactive ncurses-based process viewer for Linux
License: GPL
Group: Monitoring

Url: http://hisham.hm/htop/
Source0: %name-%version.tar.gz
Source1: %name.ru.1
Source100: %name.watch
Patch: htop-0.8.3-alt-desktop.patch
Packager: Ilya Evseev <evseev@altlinux.ru>

BuildRequires: /proc
BuildRequires: libncurses-devel ImageMagick-tools
%if_enabled unicode
BuildRequires: libncursesw-devel
%endif

%define rman1dir %_mandir/ru/man1

Summary(ru_RU.UTF-8): Интерактивный просмотр списка запущенных процессов

%description
%name is similar to top, but allows to scroll the list vertically
and horizontally to see all processes and their full command lines.

Tasks related to processes (killing,  renicing)
can be done without entering their PIDs.

%description -l ru_RU.UTF-8
%name служит для просмотра списка запущенных процессов.
По сравнению с классическим top он усовершенствован следующим образом:

  * если список процессов не влезает в экран по высоте,
    его можно пролистывать вверх/вниз,
  * если информация о процессе не влезает в экран по ширине,
    её можно прокручивать вправо/влево,
  * действия над процессами (смена приоритета, удаление)
    не требуют вручную вводить идентификатор процесса (PID),
  * возможны действия над группами процессов.

htop использует для работы с экраном библиотеку ncurses.

%prep
%setup
%patch -p1

%build
%configure -C \
	%{subst_enable openvz} \
	%{subst_enable unicode} \
	%{subst_enable taskstats} \
	%{subst_enable oom}
%make_build

%install
%makeinstall_std
install -pDm644 %SOURCE1 %buildroot%rman1dir/%name.1
install -pDm644 %name.png %buildroot%_iconsdir/hicolor/128x128/apps/%name.png

mkdir -p %buildroot%_niconsdir
convert %name.png -resize 32x32 %buildroot%_niconsdir/%name.png
rm -r %buildroot%_pixmapsdir/

%files
%_bindir/%name
%_man1dir/%name.1*
%rman1dir/%name.1*
%doc AUTHORS README ChangeLog
%_desktopdir/%name.*
%_niconsdir/%name.*
%_iconsdir/hicolor/128x128/apps/%name.png

%changelog
