Name: hugin
Version: 2016.2.0
Release: alt1.M80P.2

Summary: hugin - Goal: an easy to use cross-platform GUI for Panorama Tools.
Group: Graphics
License: GPLv2+
Url: http://hugin.sourceforge.net/

Source: %name-%version.tar
Patch1: Add-translations-in-desktop-files.patch

BuildPreReq: libpano13-devel boost-devel >= 1.34 wxGTK-devel >= 2.8.0
BuildPreReq: libgtk+2-devel >= 2.0.3 boost-thread-devel >= 1.34 gcc-c++ gcc-fortran
BuildRequires: boost-devel boost-thread-devel boost-datetime-devel boost-regex-devel
BuildRequires: boost-filesystem-devel boost-iostreams-devel boost-system-devel
BuildRequires: boost-signals-devel libglew-devel libXi-devel libXmu-devel
BuildRequires: glib-devel libgtk+2-devel libjpeg-devel libpano13-devel perl-podlators
BuildRequires: libpng-devel libstdc++-devel libtiff-devel wxGTK-devel
BuildRequires: zlib-devel libpango-devel zip cmake openexr-devel libexiv2-devel libtclap-devel
BuildRequires: liblensfun-devel libvigra-devel libgomp-devel libfftw3-devel libsqlite3-devel swig
BuildRequires: desktop-file-utils
BuildRequires: liblcms2-devel

Requires: enblend >= 3.2 libpano13 wxGTK >= 2.8.0  autopano-sift-C perl-Image-ExifTool make

%description
With hugin you can assemble a mosaic of photographs into a complete immersive
panorama, stitch any series of overlapping pictures and much more.

%prep
%setup
%patch1 -p2

%build
# reenable RPTHs because libraries in private subdirectory
%cmake -DINSTALL_XRC_DIR="/usr/share/hugin/xrc" \
	-DCMAKE_SKIP_RPATH:BOOL=OFF \
	-DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF
%cmake_build

%install
%cmakeinstall_std
%find_lang --output=%name.lang %name nona_gui
/bin/install -p -m644 -D src/hugin1/hugin/xrc/data/hugin.png %buildroot%_datadir/pixmaps/%name.png
/bin/install -p -m644 -D src/hugin1/hugin/xrc/data/hugin.png %buildroot%_niconsdir/%name.png

for file in hugin PTBatcherGUI calibrate_lens_gui pto_gen; do
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Photography \
	%buildroot%_desktopdir/$file.desktop
done

%files -f %name.lang
%doc AUTHORS README
%_bindir/*
%_desktopdir/*.desktop
%_datadir/%name/
%_datadir/pixmaps/*
%_datadir/mime/packages/hugin.xml
%_libdir/%name/
%python_sitelibdir/*
%_niconsdir/*
%_iconsdir/gnome/48x48/mimetypes/gnome-mime-application-x-ptoptimizer-script.png
%_man1dir/*
%_datadir/appdata/PTBatcherGUI.appdata.xml
%_datadir/appdata/calibrate_lens_gui.appdata.xml
%_datadir/appdata/%name.appdata.xml

%changelog
