Name: hunspell
Summary: Hunspell is a spell checker and morphological analyzer
Version: 1.6.2
Release: alt1
License: LGPL
Group: Text tools
URL: http://hunspell.sourceforge.net/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: http://downloads.sourceforge.net/%name/%name-%version.tar.gz

Patch1: hunspell-1.6.2-alt-soname.patch

BuildRequires: gcc-c++ libncursesw-devel libreadline-devel

%description
Hunspell is a spell checker and morphological analyzer program designed for
languages with rich morphology and complex word compounding or character
encoding. Hunspell interfaces: Ispell-like terminal interface using
Curses library, Ispell pipe interface, OpenOffice.org UNO module.

%package -n lib%name
Summary: Hunspell is a spell checker and morphological analyzer library
Group: System/Libraries

%description -n lib%name
Hunspell is a spell checker and morphological analyzer library designed for
languages with rich morphology and complex word compounding or character encoding.

%package -n lib%name-devel
Summary: Files for developing with hunspell
Group: Development/C++

%description -n lib%name-devel
Includes and definitions for developing with hunspell

%package utils
Summary: Morphological utilities provided with hunspell
Group: Text tools

%description utils
Morphological utilities and dictionary formatr converters provided with
hunspell.

%prep
%setup -q
%patch1 -p1

%build
%autoreconf
%configure \
	--disable-static \
	--with-ui \
	--with-readline
%make_build

%install
%make DESTDIR=%buildroot install

mkdir -p %buildroot%_datadir/myspell

%find_lang %name

%files -f %name.lang
%doc AUTHORS AUTHORS.myspell license.hunspell license.myspell NEWS THANKS
%_bindir/%name
%_man1dir/%name.1*

%files -n lib%name
%_libdir/*.so.*
%_datadir/myspell

%files -n lib%name-devel
%_includedir/%name
%_bindir/*munch
%_bindir/h*zip
%_libdir/*.so
%_pkgconfigdir/hunspell.pc
%_man1dir/h*zip.1*
%_man3dir/%name.3*

%files utils
%_bindir/analyze
%_bindir/affixcompress
%_bindir/chmorph
%_bindir/ispellaff2myspell
%_bindir/makealias
%_bindir/wordforms
%_bindir/wordlist2hunspell

%changelog
