%define status beta3

Name: hydrogen
Version: 0.9.6
Release: alt0.%status

Summary: Hydrogen Drum Machine
License: GPL
Group: Sound

Packager: Alex Karpov <karpov@altlinux.ru>

URL: http://www.hydrogen-music.org
Source0: %name-%version-%status.tar

Source1: %name-32x32.xpm
Source2: %name-16x16.xpm
Source3: %name-48x48.xpm

# Automatically added by buildreq on Thu Jan 12 2012
BuildRequires: ccmake ctest doxygen gcc-c++ graphviz ladspa_sdk libalsa-devel libarchive-devel libjack-devel liblo liblrdf-devel libportaudio2-devel libportmidi libqt4-sql-mysql librubberband-devel libsndfile-devel libtar-devel phonon-devel

BuildRequires: desktop-file-utils

%description
Hydrogen is a sample based drum machine with:
 Graphical user interface based on QT 
 Sample based real-time audio engine
 Oss Audio driver
 Jack Audio driver
 Export to disk audio driver
 Alsa Midi input
 Ability to import/export xml-based song file
 64 ticks per pattern
 16 voices with volume, mute, solo, pan capabilities
 Import of samples in wav, au, aiff format

%prep
%setup -qn %name-%version-%status

%build
export QTDIR=/usr/lib/qt4
#scons libarchive=1 prefix=%_prefix
%cmake -DWANT_RUBBERBAND=ON
cd BUILD
%make DESTDIR=%buildroot

%install
export QTDIR=/usr/lib/qt4
cd BUILD
%make_install install DESTDIR=%buildroot prefix=%_prefix

install -pD -m644 %SOURCE1 %buildroot%_niconsdir/%name.xpm
install -pD -m644 %SOURCE2 %buildroot%_miconsdir/%name.xpm
install -pD -m644 %SOURCE3 %buildroot%_liconsdir/%name.xpm

#ln -sf "$(relative %_datadir/hydrogen/data/doc %_docdir/%name-%version/doc)" html
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Midi \
	%buildroot%_desktopdir/hydrogen.desktop

%files
%_bindir/*
%_datadir/%name/
%_libdir/*.so
%_niconsdir/%name.xpm
%_liconsdir/%name.xpm
%_miconsdir/%name.xpm
#_pixmapsdir/h2-icon.svg
%_desktopdir/%name.desktop
%doc -P AUTHORS ChangeLog README.txt

%changelog
