Name: icu
Version: 5.6.1
Release: alt1.1
Epoch: 1

Summary: International Components for Unicode
Group: System/Libraries
License: X License
URL: http://www.icu-project.org/

Source: http://download.icu-project.org/files/icu4c/56.1/icu4c-56_1-src.tgz
# fc
Patch1: icu.8198.revert.icu5431.patch
Patch2: icu.8800.freeserif.crash.patch
Patch3: icu.7601.Indic-ccmp.patch
Patch4: gennorm2-man.patch
Patch5: icuinfo-man.patch
Patch6: armv7hl-disable-tests.patch

BuildRequires: doxygen gcc-c++ libstdc++-devel

%define libicu libicu56

%description
ICU is a C++ and C library that provides robust and full-featured Unicode
support

%package utils
Summary: International Components for Unicode (utilities)
Group: Text tools
Requires: %libicu = %epoch:%version-%release
Provides: icu = %version
Obsoletes: icu < %version

%description utils
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the utilites for compiling and developing
programs with ICU

%package -n %libicu
Summary: International Components for Unicode (libraries)
Group: System/Libraries
Provides: libicu = %epoch:%version-%release
Obsoletes: libicu < %epoch:%version-%release

%description -n %libicu
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the runtime libraries for ICU

%package -n libicu-devel
Summary: International Components for Unicode (development files)
Group: Development/C++
Requires: %libicu = %epoch:%version-%release
Requires: icu-utils = %epoch:%version-%release

%description -n libicu-devel
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the development files for ICU

%package samples
Summary: Sample programs for ICU
Group: Development/Other
Requires: libicu-devel = %epoch:%version-%release
BuildArch: noarch

%description samples
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains sample code for ICU

%prep
%setup -c
%setup -DT -n %name-%version/icu
%patch1 -p2 -R -b .icu8198.revert.icu5431.patch
%patch2 -p1 -b .icu8800.freeserif.crash.patch
%patch3 -p1 -b .icu7601.Indic-ccmp.patch
%patch4 -p1 -b .gennorm2-man.patch
%patch5 -p1 -b .icuinfo-man.patch
%ifarch armv7hl
%patch6 -p1 -b .armv7hl-disable-tests.patch
%endif

%build
cd source
%autoreconf
%configure \
	--disable-samples \
	--disable-static
%make_build

%install
cd source
%makeinstall_std
cp -a samples %buildroot%_datadir/icu
rm -f %buildroot%_bindir/icuinfo

%files utils
%_bindir/*
%exclude %_bindir/icu-config
%_sbindir/*
%exclude %_man1dir/icu-config.1*
%_man1dir/*
%_man8dir/*

%files -n %libicu
%doc *.html *.css
%_libdir/*.so.*

%files -n libicu-devel
%_includedir/*
%_bindir/icu-config
%_libdir/*.so
%_libdir/icu
%_pkgconfigdir/*.pc
%_datadir/icu
%exclude %_datadir/icu/samples
%_man1dir/icu-config.1*

%files samples
%_datadir/icu/samples

%changelog
