%define _name icu
%define ver_major 5.1

Name: %_name%ver_major
Version: %ver_major.1
Release: alt6
Epoch: 1

Summary: International Components for Unicode
Group: System/Libraries
License: X License
URL: http://www.icu-project.org/

Source: http://download.icu-project.org/files/icu4c/5.1.1/icu4c-50_1_1-src.tgz
# https://bugs.gentoo.org/show_bug.cgi?id=439892
Patch: libicu-5.1-up-disable_c++11_test.patch
Patch1: icu-5.1.1-alt-fix.patch

BuildRequires: doxygen gcc-c++ libstdc++-devel

%define libicu libicu50

%description
ICU is a C++ and C library that provides robust and full-featured Unicode
support

%package -n %libicu
Summary: International Components for Unicode (libraries)
Group: System/Libraries
Provides: libicu = %epoch:%version-%release
Obsoletes: libicu < %epoch:%version-%release

%description -n %libicu
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the runtime libraries for ICU

%package -n lib%name-devel
Summary: International Components for Unicode (development files)
Group: Development/C++
Requires: %libicu = %epoch:%version-%release
#Requires: icu-utils = %epoch:%version-%release
Conflicts: lib%_name-devel

%description -n lib%name-devel
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the development files for ICU

%package utils
Summary: International Components for Unicode (utilities)
Group: Text tools
Requires: %libicu = %epoch:%version-%release
Provides: icu = %version
Obsoletes: icu < %version

%description utils
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the utilites for compiling and developing
programs with ICU

%package samples
Summary: Sample programs for ICU
Group: Development/Other
Requires: libicu-devel = %epoch:%version-%release
BuildArch: noarch

%description samples
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains sample code for ICU

%prep
%setup -c
%setup -DTn %name-%version/icu
%patch -p1
%patch1 -p2

%build
cd source
%autoreconf
%configure \
	--disable-samples \
	--disable-static
%make_build

%install
cd source
%makeinstall_std
cp -a samples %buildroot%_datadir/icu
rm -f %buildroot%_bindir/icuinfo


%files -n %libicu
%_libdir/*.so.*

%if 0
%files -n lib%name-devel
%_includedir/*
%_bindir/icu-config
%_libdir/*.so
%_libdir/icu
%_pkgconfigdir/*.pc
%_datadir/icu
%exclude %_datadir/icu/samples
%_man1dir/icu-config.1*

%files utils
%_bindir/*
%exclude %_bindir/icu-config
%_sbindir/*
%exclude %_man1dir/icu-config.1*
%_man1dir/*
%_man8dir/*

%files samples
%_datadir/icu/samples
%endif

%changelog
