%define name imapproxy
%define distname up-%name
%define _ssldir %_sysconfdir/ssl/imapproxy

Name: imapproxy
Version: 1.2.7
Release: alt1

Summary: Proxy for the IMAP protocol

License: GPLv2+
Group: System/Servers
Url: http://www.imapproxy.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://www.imapproxy.org/downloads/%distname-%version.tar
Source1: %name.init

Patch: %name-1.2.7-conf.patch
Patch1: %name-alt.patch

# Automatically added by buildreq on Sat Feb 25 2012
# optimized out: libcom_err-devel libkrb5-devel libtinfo-devel
BuildRequires: libncurses-devel libssl-devel libwrap-devel

%description
Imapproxy proxies IMAP transactions between an IMAP client and an IMAP
server. The connection to the server is kept open and cached for a
time after the client closes its side, in order to reuse it when the
client tries to open another one to the same IMAP server with the same
user ID.

%prep
%setup -n %distname-%version
%patch0 -p1 -b .init
%patch1 -p2

%build
# fixes https://qa.mandriva.com/show_bug.cgi?id=37974
CFLAGS="`echo $CFLAGS | sed 's/-Wp,-D_FORTIFY_SOURCE=2//'`"

# kerberos include is needed (because of openssl-0.9.7 ?)
export CPPFLAGS="$CPPFLAGS -I%prefix/kerberos/include"
%configure
%make_build

%install
mkdir -p %buildroot%_sbindir \
	%buildroot%_initdir \
	%buildroot%_ssldir

install -m 755 bin/in.imapproxyd %buildroot%_sbindir/
install -m 755 bin/pimpstat %buildroot%_sbindir/
install -m 644 scripts/%name.conf %buildroot%_sysconfdir/
install -m 755 %SOURCE1 %buildroot%_initdir/%name

%files
%doc copyright ChangeLog README README.ssl README.known_issues
%dir %_ssldir
%_sbindir/in.imapproxyd
%_sbindir/pimpstat
%_initdir/%name
%config(noreplace) %_sysconfdir/%name.conf

%changelog
