%define shortname indi


Name: indilib
Version: 1.6.2
Release: alt1%ubt

%add_verify_elf_skiplist %_libdir/libindidriver.so.%version
%add_verify_elf_skiplist %_libdir/libindimain.so.%version
%add_verify_elf_skiplist %_libdir/libindiAlignmentDriver.so.%version

Group: Development/C
Summary: Library to control astronomical devices
Url: http://indi.sourceforge.net/
License: LGPLv2+

Provides: %shortname = %version-%release
Conflicts: kde4edu-kstars < 4.1.60
Conflicts: kdeedu-kstars <= 3.5.10-alt2

# http://nchc.dl.sourceforge.net/sourceforge/indi/
Source: lib%{shortname}_%version.tar

# Automatically added by buildreq on Wed Oct 05 2011 (-bi)
# optimized out: cmake-modules elfutils libstdc++-devel pkg-config zlib-devel
#BuildRequires: boost-devel-headers cmake gcc-c++ libcfitsio-devel libnova-devel libusb-compat-devel zlib-devel-static
BuildRequires(pre): rpm-build-ubt
BuildRequires: boost-devel cmake gcc-c++ libcfitsio-devel libnova-devel libusb-compat-devel zlib-devel
BuildRequires: libusb-devel libjpeg-devel libgsl-devel libcurl-devel
BuildRequires: kde-common-devel

%description
INDI is an instrument neutral distributed interface control protocol
that aims to provide backend driver support and automation for a wide
range of Astronomical devices (telescopes, focusers, CCDs..etc).

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Conflicts: indilib <= 1.5.0-alt2
%description common
%name common package

%package -n libsbigudrv
Summary: Librar file for INDI
Group: Development/C
Requires: %name-common = %EVR
%description -n libsbigudrv
  INDI is an instrument neutral distributed interface control protocol
that aims to provide backend driver support and automation for a wide
range of Astronomical devices (telescopes, focusers, CCDs..etc).
  This package contains library files of indilib.

%package -n lib%shortname
Group: System/Libraries
Summary: Library to control astronomical devices
Requires: %name-common = %EVR
%description -n lib%shortname
INDI is an instrument neutral distributed interface control protocol
that aims to provide backend driver support and automation for a wide
range of Astronomical devices (telescopes, focusers, CCDs..etc).

%package -n lib%shortname-devel
Summary: INDI devellopment files
Group: Development/C
Requires: %name-common = %EVR
Provides: %shortname-devel = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel < %version-%release
%description -n lib%shortname-devel
  INDI is an instrument neutral distributed interface control protocol
that aims to provide backend driver support and automation for a wide
range of Astronomical devices (telescopes, focusers, CCDs..etc).
  This package contains files need to build applications using indilib.

%prep
%setup -q -n lib%{shortname}_%version
chmod -x drivers/telescope/lx200fs2.{h,cpp}

%build
%Kbuild \
    -DUDEVRULES_INSTALL_DIR=%_udevrulesdir \
    #

%install
%Kinstall

%files common
%doc ChangeLog README
# an essential part of libindi according to FindINDI.cmake
%_datadir/%shortname/

%files
%_bindir/*
%_udevrulesdir/*.rules

%files -n lib%shortname
#%_libdir/libindi.so.1
#%_libdir/libindi.so.1.*
%_libdir/libindiAlignmentDriver.so.1
%_libdir/libindiAlignmentDriver.so.1.*
%_libdir/libindidriver.so.1
%_libdir/libindidriver.so.1.*
# an essential part of libindi according to FindINDI.cmake
%_libdir/%shortname/

#%files -n libsbigudrv
#%_libdir/libsbigudrv.so.*

%files -n lib%shortname-devel
%doc TODO
#%doc src/examples
%_libdir/*.so
%_libdir/*.a
%_includedir/libindi
%_pkgconfigdir/libindi.pc

%changelog
