%define iperf_user _iperf
%define iperf_group _iperf
%define iperf_home %_localstatedir/%name

Name: iperf
Version: 2.0.5
Release: alt4

Summary: Iperf was developed as a modern alternative for measuring TCP and UDP bandwidth performance
License: BSD
Group:  Monitoring

URL: http://iperf.sourceforge.net
Packager: Evgenii Terechkov <evg@altlinux.org>
Source0: %name-%version-source.tar
Source1: iperf-tcp.init
Source2: iperf-udp.init
Source3: iperf.sysconfig
Source4: iperf-tcp.service
Source5: iperf-udp.service

Patch0: high-latency.patch
Patch1: 006-bidirectional-tcp-server.patch
Patch2: 001-cast-to-max_size_t-instead-of-int.patch
Patch3: 002-typo-recieve.patch
Patch4: 003-fix-hyphen-used-as-minus-sign.patch
Patch5: 005-iperf-die-on-bind-fail.patch
Patch6: 010-fix-format-security-ftbfs.patch
Patch7: 011-ipv6_mcast_check.patch


BuildRequires: gcc-c++

%description
Iperf is a tool to measure maximum TCP bandwidth, allowing the tuning of various
parameters and UDP characteristics. Iperf reports bandwidth, delay jitter,
datagram loss. 

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1

%build
%configure
%make

%install
%makeinstall

install -pdm1770 %buildroot/%_localstatedir/%name

install -pDm0755 %SOURCE1 %buildroot/%_initdir/iperf-tcp
install -pDm0755 %SOURCE2 %buildroot/%_initdir/iperf-udp

install -pDm0644 %SOURCE4 %buildroot/%_unitdir/iperf-tcp.service
install -pDm0644 %SOURCE5 %buildroot/%_unitdir/iperf-udp.service

install -pDm0644 %SOURCE3 %buildroot/%_sysconfdir/sysconfig/%name

rm -f doc/Makefile*

%pre
/usr/sbin/groupadd -r -f %iperf_group ||:
/usr/sbin/useradd -g %iperf_group -c 'The iperf Daemons' \
	-d %iperf_home -s /dev/null -r %iperf_user >/dev/null 2>&1 ||:

%post
%post_service %name-tcp
%post_service %name-udp

%preun
%preun_service %name-tcp
%preun_service %name-udp

%files
%_bindir/%name
%_initdir/%{name}-*
%_unitdir/%{name}-*.service
%_man1dir/%name.1.*
%config(noreplace) %_sysconfdir/sysconfig/%name
%dir %attr(1770,root,%iperf_group) %_localstatedir/%name
%doc README doc/* ChangeLog AUTHORS

%changelog
