%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl

Name: ipopt
Version: 3.11.6
Release: alt1.svn20140513
Summary: Large-Scale Nonlinear Optimization Solver (Interior Point OPTimizer)
License: CPL 1.0
Group: Sciences/Mathematics
Url: http://www.coin-or.org/projects/Ipopt.xml
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://projects.coin-or.org/svn/Ipopt/trunk
Source: Ipopt-%version.tar.gz

BuildPreReq: liblapack-devel libparmetis-devel libmumps-devel
BuildPreReq: gcc-fortran gcc-c++ %mpiimpl-devel libscotch-devel
BuildPreReq: libblacs-devel libscalapack-devel CoinBuildTools
BuildPreReq: doxygen graphviz latex2html

%description
Ipopt (Interior Point OPTimizer, pronounced I-P-Opt) is a software
package for large-scale nonlinear optimization. It is designed to find
(local) solutions of mathematical optimization problems of the from

   min     f(x)
   x in R^n

   s.t.       g_L <= g(x) <= g_U
              x_L <=  x   <= x_U

where f(x): R^n --> R is the objective function, and g(x): R^n --> R^m
are the constraint functions. The vectors g_L and g_U denote the lower
and upper bounds on the constraints, and the vectors x_L and x_U are the
bounds on the variables x. The functions f(x) and g(x) can be nonlinear
and nonconvex, but should be twice continuously differentiable. Note
that equality constraints can be formulated in the above formulation by
setting the corresponding components of g_L and g_U to the same value.

%package -n lib%name
Summary: Shared libraries of Ipopt
Group: System/Libraries

%description -n lib%name
Ipopt (Interior Point OPTimizer, pronounced I-P-Opt) is a software
package for large-scale nonlinear optimization. It is designed to find
(local) solutions of mathematical optimization problems.

This package contains shared libraries of Ipopt.

%package -n lib%name-devel
Summary: Development files of Ipopt
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-devel
Ipopt (Interior Point OPTimizer, pronounced I-P-Opt) is a software
package for large-scale nonlinear optimization. It is designed to find
(local) solutions of mathematical optimization problems.

This package contains development files of Ipopt.

%package -n lib%name-devel-doc
Summary: Documentation for Ipopt
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
Ipopt (Interior Point OPTimizer, pronounced I-P-Opt) is a software
package for large-scale nonlinear optimization. It is designed to find
(local) solutions of mathematical optimization problems.

This package contains development documentation for Ipopt.

%package examples
Summary: Examples for Ipopt
Group: Development/Documentation
BuildArch: noarch

%description examples
Ipopt (Interior Point OPTimizer, pronounced I-P-Opt) is a software
package for large-scale nonlinear optimization. It is designed to find
(local) solutions of mathematical optimization problems.

This package contains examples for Ipopt.

%prep
%setup

mkdir -p BuildTools
cp -f %_datadir/BuildTools/* %_datadir/libtool/*.m4 \
	BuildTools/

%build
mpi-selector --set %mpiimpl
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed -Wl,-rpath,%mpidir/lib -L%mpidir/lib"

INCS="-I%_includedir/parmetis -I%mpidir/include"
%add_optflags $INCS %optflags_shared -DHAVE_SNPRINTF
sed -i 's|@MPIDIR@|%mpidir|g' Ipopt/configure.ac
sed -i "s|@TOPDIR@|$PWD|g" Ipopt/configure.ac
%autoreconf
#run_autotools

#pushd Ipopt
MUMPS="-lcmumps -ldmumps -lsmumps -lzmumps -lmumps_common -lpord"
BLASLAPACK="-llapack -lopenblas"
%configure \
	--disable-mumps-libcheck \
	--with-blas="$BLASLAPACK" \
	--with-lapack="$BLASLAPACK" \
	--with-metis="-L%mpidir/lib -lparmetis" \
	--with-metis-incdir=%mpidir/include/metis \
	--with-mumps-incdir=%_includedir \
	--with-mumps-lib="$MUMPS"
sed -i '1a\echo=echo' libtool
%make_build TOPDIR=$PWD
#popd

# very long
#pushd Ipopt/doc
#./makehtml.sh
#popd

pushd doxydoc
doxygen doxygen.conf
popd

%install
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed -Wl,-rpath,%mpidir/lib -L%mpidir/lib"

#pushd Ipopt
%makeinstall_std TOPDIR=$PWD

pushd Ipopt/src/LinAlg
	for i in *.hpp; do
		if [ "$i" != "IpMatrix.hpp" -a "$i" != IpSymMatrix.hpp -a "$i" != "IpVector.hpp" ];
		then
			install -p -m644 $i %buildroot%_includedir/coin
		fi
	done
popd
install -p -m644 Ipopt/src/LinAlg/TMatrices/*.hpp \
	%buildroot%_includedir/coin
pushd Ipopt/src/Algorithm
	for i in *.hpp */*.hpp; do
		cp $i %buildroot%_includedir/coin/ ||:
	done
popd

install -d %buildroot%_docdir/coin
mv %buildroot%_datadir/coin/doc/Ipopt %buildroot%_docdir/coin/

#cp -fR Ipopt/tutorial Ipopt/doc/documentation Ipopt/examples \
cp -fR Ipopt/tutorial Ipopt/examples doxydoc/doxydoc/html \
	%buildroot%_docdir/coin/Ipopt/
#popd

rm -fR %buildroot%_datadir/coin/doc

%files
%doc ChangeLog Ipopt/AUTHORS Ipopt/LICENSE Ipopt/README

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%dir %_includedir/coin
%_includedir/coin/*
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%dir %_docdir/coin
%doc %_docdir/coin/Ipopt
%exclude %_docdir/coin/Ipopt/examples

%files examples
%dir %_docdir/coin
%dir %_docdir/coin/Ipopt
%_docdir/coin/Ipopt/examples

%changelog
