%define prefix /
%define exec_prefix /
%define _prefix /
Name: ipset
Version: 6.32
Release: alt1%ubt

Summary: Tools for managing sets of IP or ports with iptables
License: GPLv2
Group: System/Kernel and hardware
Url: http://ipset.netfilter.org/

Source0: %name-%version.tar
Patch0: %name-%version-alt.patch
BuildRequires: libmnl-devel
BuildRequires(pre): rpm-build-ubt

%description
IP sets are a framework inside the Linux kernel, which can be administered by 
the ipset utility. Depending on the type, currently an IP set may store IP addresses,
(TCP/UDP) port numbers or IP addresses with MAC addresses in a way,
which ensures lightning speed when matching an entry against a set.

ipset may be the proper tool for you, if you want to
 * store multiple IP addresses or port numbers and match against the
   collection by iptables at one swoop;
 * dynamically update iptables rules against IP addresses or ports
   without performance penalty;
 * express complex IP address and ports based rulesets with one single
   iptables rule and benefit from the speed of IP sets

%package -n lib%{name}6
Summary: Dynamic library for %name
License: LGPLv2+
Group: Development/C

%description -n lib%{name}6
The lib%{name}6 package contains the dynamic libraries needed for 
applications to use the %name framework.

%package -n lib%{name}-devel
Summary: Header files for lin%name
License: LGPLv2+
Group: Development/C
Requires: lib%{name}6 = %version-%release

%description -n lib%{name}-devel
The lib%{name}6 package contains the header files needed for
developing applications that need to use the %name framework libraries.


%package -n kernel-source-ipset
Summary: Linux ipset modules sources
License: GPLv2+
Group: Development/Kernel
BuildArch: noarch
BuildPreReq: rpm-build-kernel

%description -n kernel-source-ipset
Kernel source modules ipset.

%prep
%setup -q
%patch0 -p1
autoreconf -fisv

%build
%configure --without-kbuild --without-ksource
%make_build LIBDIR=/%_lib/ BINDIR=/sbin/
%install
%makeinstall prefix=%buildroot/ exec_prefix=%buildroot/ sbindir=%buildroot/sbin libdir=%buildroot/%_lib pkgconfigdir=%buildroot/%_pkgconfigdir
mkdir -p $RPM_BUILD_ROOT/%_libdir
pushd $RPM_BUILD_ROOT/%_libdir
LIBNAME=`basename \`ls $RPM_BUILD_ROOT/%{_lib}/libipset.so.3.*.*\``
ln -s ../../%{_lib}/$LIBNAME libipset.so
popd

tar xvf %SOURCE0
mv %name-%version kernel-source-%name-%version

mkdir -p %kernel_srcdir
tar -cjf %kernel_srcdir/kernel-source-%name-%version.tar.bz2 kernel-source-%name-%version

%files
%doc ChangeLog ChangeLog.ippool README
/sbin/*
%_man8dir/*

%files -n lib%{name}6
%attr(755,root,root) /%{_lib}/libipset.so.3*

%files -n lib%{name}-devel
%_includedir/lib%name/*.h
%_libdir/*.so
%_pkgconfigdir/*.pc

%files -n kernel-source-ipset
%attr(0644,root,root) %kernel_src/kernel-source-%name-%version.tar.bz2

%changelog
