%define prefix /
%define exec_prefix /
%define _prefix /
%define origname ipset
Name: ipset6
Version: 6.8
Release: alt2

Summary: Tools for managing sets of IP or ports with iptables
License: GPLv2
Group: System/Kernel and hardware
Url: http://ipset.netfilter.org/

Source0: %name-%version.tar
Patch0: %name-%version-%release.patch
BuildRequires: libmnl-devel

%description
IP sets are a framework inside the Linux 2.4.x and 2.6.x kernel,
which can be administered by the ipset utility.
Depending on the type, currently an IP set may store IP addresses,
(TCP/UDP) port numbers or IP addresses with MAC addresses in a way,
which ensures lightning speed when matching an entry against a set.

ipset may be the proper tool for you, if you want to
 * store multiple IP addresses or port numbers and match against the
   collection by iptables at one swoop;
 * dynamically update iptables rules against IP addresses or ports
   without performance penalty;
 * express complex IP address and ports based rulesets with one single
   iptables rule and benefit from the speed of IP sets

%prep
%setup -q
%patch0 -p1
autoreconf -fisv

%build
%configure --without-kbuild --without-ksource
%make_build LIBDIR=/%_lib/ BINDIR=/sbin/

%install
%makeinstall prefix=%buildroot/ exec_prefix=%buildroot/ sbindir=%buildroot/sbin libdir=%buildroot/%_lib

%files
%doc ChangeLog ChangeLog.ippool README
/sbin/*
%_man8dir/*

%changelog
