Name: irssi
Version: 0.8.21
Release: alt0.M80P.1

Summary: Modular text mode IRC client with Perl scripting
License: GPLv2+
Group: Networking/IRC
Url: https://irssi.org/
# https://github.com/irssi/irssi.git
# git://git.altlinux.org/gears/i/irssi.git
Source: %name-%version-%release.tar
Source1: %name.desktop
Patch1: %name-0.8.21-alt-tls-sites.patch
Patch2: %name-0.8.21-alt-strict-subs-syntax.patch

BuildRequires: elinks glib2-devel libssl-devel libtinfo-devel perl-devel

%description
Irssi is a modular textUI IRC client with Perl scripting.

%package devel
Summary: Header files for irssi plugins development
Group: Development/C
Requires: %name = %EVR

%description devel
This package contains header files for the development of irssi plugins.

%package perl
Group: Networking/IRC
Summary: Perl scripts for irssi
Requires: %name = %EVR

%description perl
This package contains perl scripts for irssi.

%prep
%setup -n %name-%version-%release
%patch1 -p1
%patch2 -p1

# no use to run autoreconf twice.
sed -i 's/^autoreconf.*/%autoreconf || exit/' autogen.sh

# workaround the absence of irssi.git
sed -i 's/^git log /: &/' autogen.sh
# git log -1 --pretty=format:%%ai %version > date-%version
echo '2017-01-03 14:24:55 +0100' > date-0.8.21
sed -i 's/^DATE=.*/DATE="$(cat date-%version)"/' irssi-version.sh

%build
NOCONFIGURE=1 ./autogen.sh

%add_optflags -fpie
export LDFLAGS=-pie
%configure \
	--disable-silent-rules \
	--disable-static \
	--enable-ipv6 \
	--without-ncurses \
	--without-socks \
	--with-bot \
	--with-modules \
	--with-perl=module \
	--with-perl-lib=vendor \
	--with-proxy \
	--with-terminfo \
	--with-textui \
	#

%make_build

%install
%makeinstall_std

%define irssi_modules_dir %_libdir/irssi/modules
rm %buildroot%irssi_modules_dir/lib*.la

install -pm644 AUTHORS NEWS %buildroot%_docdir/irssi/

install -pDm644 irssi-icon.png %buildroot%_iconsdir/irssi.png
install -pDm644 %SOURCE1 %buildroot%_desktopdir/irssi.desktop

%add_findreq_skiplist %_datadir/irssi/scripts/*
export RPM_LD_PRELOAD_irssi=%buildroot%_bindir/irssi
export RPM_FILES_TO_LD_PRELOAD_irssi='%irssi_modules_dir/lib*.so %perl_vendor_autolib/Irssi/*.so'
export RPM_LD_PRELOAD_libperl_core='%buildroot%irssi_modules_dir/libperl_core.so'
export RPM_FILES_TO_LD_PRELOAD_libperl_core='%irssi_modules_dir/libfe_perl.so %perl_vendor_autolib/Irssi/*.so'
%set_verify_elf_method strict

%files
%config(noreplace) %_sysconfdir/irssi.conf
%_bindir/*
%_datadir/irssi/
%exclude %_datadir/irssi/scripts/
%_libdir/irssi/
%exclude %irssi_modules_dir/*perl*.so
%_iconsdir/*.png
%_desktopdir/*.desktop
%_mandir/man?/*
%_docdir/irssi/

%files perl
%dir %_datadir/irssi/
%_datadir/irssi/scripts/
%perl_vendor_archlib/Irssi*
%perl_vendor_autolib/Irssi
%dir %_libdir/irssi/
%dir %irssi_modules_dir/
%irssi_modules_dir/*perl*.so

%files devel
%_includedir/irssi/

%changelog
