Name: jabber-pyicqt
Version: 0.8.1.5
Release: alt1.1

Summary: ICQ transport for XMPP servers
License: GPL
Group: System/Servers
Url: http://pyicqt.googlecode.com
Packager: Sergey Bolshakov <sbolshakov@altlinux.ru>

Requires(pre): shadow-utils
Requires(post): %post_service jabber-common
Requires(preun): %preun_service
# more uncatched reqs:
Requires: python-module-twisted-web
Requires: python-module-twisted-words

Provides: pyicq-t = %version-%release
Obsoletes: pyicq-t

BuildRequires(pre): jabber-common
BuildRequires: python-devel

Source0: %name-%version-%release.tar

%package mysql
Summary: ICQ transport for XMPP servers -- MySQL connector
Group: System/Servers
Requires: %name == %version-%release

%package pgsql
Summary: ICQ transport for XMPP servers -- PgSQL connector
Group: System/Servers
Requires: %name == %version-%release

%description
%name is a ICQ transport for Jabber servers.
this package contains only `xmlfiles' backend,
see %name-mysql or %name-pgsql packages.

%description mysql
%name is a ICQ transport for Jabber servers.
this package contains MySQL backend for %name

%description pgsql
%name is a ICQ transport for Jabber servers.
this package contains PostgreSQL backend for %name

%prep
%setup
sed -i 's/@altversion@/%version-%release/' src/services/VersionTeller.py
sed -i 's,/usr/lib,%_libdir,' pyicqt.init

%install
mkdir -p %buildroot%_var/run/pyicqt %buildroot%_var/log/pyicqt %buildroot%_spooldir/pyicqt
install -pm0644 -D PyICQt.py %buildroot%_libdir/pyicqt/PyICQt.py
find src data -type f -not '(' -path 'src/web/*' -o -path 'data/www/*' ')' |\
    cpio -pmdv %buildroot%_libdir/pyicqt
install -pm 0755 -D pyicqt.init %buildroot%_initdir/%name
install -pm 0755 -D pyicqt.adapter %buildroot%_jabber_component_dir/pyicqt
install -pm 0640 -D config_example.xml %buildroot%_sysconfdir/pyicqt.xml
install -pm 0644 -D pyicqt.sysconfig %buildroot%_sysconfdir/sysconfig/pyicqt
install -pm 0640 -D pyicqt.logrotate %buildroot%_sysconfdir/logrotate.d/pyicqt

%add_python_lib_path %_libdir/pyicqt/src
%add_python_lib_path %_libdir/pyicqt/lang
%set_python_req_method strict
# mask req to full-blown p-i-l
%add_python_req_skip Image

%pre
/usr/sbin/groupadd -r -f _pyicqt &>/dev/null ||:
/usr/sbin/useradd -r -g _pyicqt -d /dev/null -s /dev/null \
    -c "ICQ Jabber transport" -M -n _pyicqt &>/dev/null ||:

%post
%post_service %name
%_jabber_config

%preun
%preun_service %name

%files
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README tools
%attr(0640,root,_pyicqt) %config(noreplace) %_sysconfdir/pyicqt.xml
%config(noreplace) %_sysconfdir/sysconfig/pyicqt
%attr(640,root,root) %config %_sysconfdir/logrotate.d/pyicqt

%_initdir/%name

%_libdir/pyicqt
%exclude %_libdir/pyicqt/src/xdb/mysql.py*
%exclude %_libdir/pyicqt/src/xdb/postgresql.py*

%_jabber_component_dir/pyicqt

%attr(0770,root,_pyicqt) %dir %_spooldir/pyicqt
%attr(0770,root,_pyicqt) %dir %_var/run/pyicqt
%attr(0770,root,_pyicqt) %dir %_var/log/pyicqt

%files mysql
%_libdir/pyicqt/src/xdb/mysql.py*

%files pgsql
%_libdir/pyicqt/src/xdb/postgresql.py*

%changelog
