Group: Development/Java
BuildRequires: jdepend
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
%define fedora 23
# %%name or %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name jboss-marshalling
%define version 1.4.6
%global namedreltag .Final
%global namedversion %{version}%{?namedreltag}

Name:             jboss-marshalling
Version:          1.4.6
Release:          alt1_2jpp8
Summary:          JBoss Marshalling
License:          LGPLv2+
URL:              http://www.jboss.org/jbossmarshalling
BuildArch:        noarch

Source0:          https://github.com/jboss-remoting/jboss-marshalling/archive/%{namedversion}.tar.gz

BuildRequires:    maven-local
BuildRequires:    jboss-parent
BuildRequires:    jboss-modules
BuildRequires:    maven-injection-plugin
%if 0%{?fedora}
BuildRequires:    apiviz
%endif
Source44: import.info

%description
JBoss Marshalling is an alternative serialization API that fixes many
of the problems found in the JDK serialization API while remaining
fully compatible with java.io.Serializable and its relatives, and adds
several new tunable parameters and additional features, all of which
are pluggable via factory configuration (externalizers, class/instance
lookup tables, class resolution, and object replacement, to name a
few).

%package javadoc
Group: Development/Java
Summary:          API documentation for %{name}
BuildArch: noarch

%description javadoc
This package contains %{summary}.

%prep
%setup -q -n %{name}-%{namedversion}

%pom_remove_plugin :maven-shade-plugin
%pom_disable_module tests
%pom_disable_module osgi

# Conditionally remove dependency on apiviz
if [ %{?rhel} ]; then
    %pom_remove_plugin :maven-javadoc-plugin
fi

%build
%mvn_build

%install
%mvn_install

%files -f .mfiles
%doc LICENSE.txt

%files javadoc -f .mfiles-javadoc
%doc LICENSE.txt

%changelog
