%def_disable plugin

%ifarch %arm ppc ppc64
# not yet ported
%def_without sinjdoc
%else
%def_with sinjdoc
%endif

# note: at sync with fedora rel.28

Name: jdkgcj
Version: 0.5.12
Release: alt1

Summary: A free Java SDK
License: GPL
Group: Development/Java
Url: http://www.arklinux.org/projects/jdkgcj

# temporary: should be version
%define javafullver 1.5.0.0
# the version string for the java-gcj-compat release we require
%define jgcver          1.0.70

# standard JPackage naming and versioning defines
%define origin          gcj
%define priority        1490
#define priority        1500
%define javaver         1.5.0
%define buildver        0

%define jppname            java-%{javaver}-%{origin}

%define sdkdir          %{jppname}-%__gcc_version_base-%{javafullver}
%define java_home   %_jvmdir/%sdkdir
%define jredir      %sdkdir/jre
%define sdkbindir   %java_home/bin
%define jrebindir   %java_home/jre/bin
%define jvmjardir   %{_jvmjardir}/%sdkdir
%define sdklnk          java-%{javaver}-%{origin}
%define jrelnk          jre-%{javaver}-%{origin}

%if_enabled plugin
%define plugindir       %{_libdir}/mozilla/plugins
%endif


# a must for java-1.5.0-gcj-devel
Requires: libgcj%__gcc_version_base-jar
Requires: libgcj%__gcc_version_base-plugins
BuildRequires(pre): alternatives >= 0:0.4
BuildRequires(pre): rpm-build-java

Source: %name-%version.tar
Source1: altgcj-%version.tar
Source2: %name-refentry.xml

%set_compress_method gzip

BuildRequires: gcc%__gcc_version_base-java xmlto

Requires: java-1.5.0-gcj = %version-%release
#Requires: java-1.5.0-gcj-devel = %version-%release

#%package -n %jppname-devel
#Group: Development/Java
#Summary: JPackage development compatibility layer for GCJ
# java-x.x.x-gcj compatible provides
#------------------------------------
Requires: java-1.5.0-gcj-aot-compile
Provides: java-gcj-compat-devel = %jgcver
Provides: java-1.5.0-gcj-devel = %javafullver
#------------------------------------
# standard JPackage devel provides
#Provides: java-sdk-%{javaver}-%{origin} = %{version}
#Provides: java-sdk-%{javaver} = %{version}
#Provides: java-sdk-%{origin} = %{version}
#Provides: java-sdk = %{javaver}
#Provides: java-%{javaver}-devel = %{version}
#Provides: java-devel-%{origin} = %{version}
#Provides: java-devel = %{javaver}
%if_with sinjdoc
Requires: sinjdoc
%endif

# jre
%package -n %jppname
Group: Development/Java
Summary: JPackage runtime compatibility layer for GCJ

# due to GC Warning: Couldn't read /proc/stat and errors
Requires: /proc
Requires(pre): /proc
PreReq: gcc%__gcc_version_base-java
Requires: gcc-java-common >= 1.4.12-alt1
Requires: java-common >= 1.1

Provides: java-gcj-compat = %jgcver
Provides: java-1.5.0-gcj = %javafullver

# standard JPackage base provides
#Provides: jre-%{javaver}-%{origin} = %{version}-%{release}
#Provides: jre-%{origin} = %{version}-%{release}
#Provides: jre-%{javaver} = %{version}-%{release}
#Provides: java-%{javaver} = %{version}-%{release}
#Provides: jre = %{javaver}
#Provides: java-%{origin} = %{version}-%{release}
#Provides: java = %{javaver}

%description
jdkgcj provides an interface to gcj that is compatible with the Sun and IBM
Java Development Kits (JDKs).
jdkgcj provides the javac, java and javah tools as well as jni.h, allowing
you to compile java extensions using JNI.

%description -n %jppname
This package installs directory structures, shell scripts and symbolic
links to simulate a JPackage-compatible runtime environment with GCJ.

#%description -n %jppname-devel
#This package installs directory structures, shell scripts and symbolic
#links to simulate a JPackage-compatible development environment with
#GCJ.

%prep
%setup -n %name -a1

%build
%configure \
	--prefix=%java_home \
	--bindir=%sdkbindir \
	--includedir=%java_home/include
xmlto -o man man %SOURCE2

%install
rln()
{
	local target=$1 && shift
	local source=$1 && shift
	ln -rsnf "%buildroot$target" "%buildroot$source" "$@"
}
%makeinstall_std

# install operating system include directory
install -dm 755 $RPM_BUILD_ROOT%{_jvmdir}/%{sdkdir}/include/linux

# install libjvm.so directories
install -dm 755 $RPM_BUILD_ROOT%{_jvmdir}/%{jredir}/lib/%{_arch}/client
install -dm 755 $RPM_BUILD_ROOT%{_jvmdir}/%{jredir}/lib/%{_arch}/server

# install tools.jar directory
install -dm 755 $RPM_BUILD_ROOT%{_jvmdir}/%{sdkdir}/lib

pushd $RPM_BUILD_ROOT%{_jvmdir}/%{sdkdir}/jre/lib
  for jarname in jaas jce jdbc-stdext jndi jndi-cos jndi-dns \
    jndi-ldap jndi-rmi jsse sasl
  do
    ln -s rt.jar $jarname.jar
  done
popd

rln %_bindir/fastjar %sdkbindir/jar
for i in appletviewer keytool jarsigner javah orbd rmic rmid rmiregistry serialver tnameserv; do
      	#rln %_bindir/gcj %sdkbindir/$i
	rln %_bindir/g$i %sdkbindir/$i
done

install -p -m755 altgcj/jdkgcj-notimpl.sh %buildroot%sdkbindir/notimpl
install -pD -m755 altgcj/rebuild-gcj-db %buildroot%_bindir/rebuild-gcj-db
install -pD -m755 altgcj/rebuild-gcj-db.filetrigger %buildroot/usr/lib/rpm/rebuild-gcj-db.filetrigger

mkdir -p %buildroot%java_home/man/man1
install -pm644 man/javac.1 %buildroot%java_home/man/man1/jdkgcj.1
for f in javac javah jar rmic; do
	ln -s jdkgcj.1 %buildroot%java_home/man/man1/"$f".1
done

gcj_target_libdir=`gcj -print-search-dirs |sed -ne 's|^install: \(/.*\)/$|\1|p'`
for f in java javax jvmpi.h; do
	rln "$gcj_target_libdir/include/$f" %java_home/include/
done

for i in extcheck idlj javap jdb native2ascii; do
	ln -snf notimpl %buildroot%sdkbindir/$i
done
%if_with sinjdoc
rln %_bindir/sinjdoc %sdkbindir/javadoc
%else
ln -snf notimpl %buildroot%sdkbindir/javadoc
%endif #sinjdoc

# jre dir and stuff
mkdir -p %buildroot%jrebindir
pushd %buildroot%sdkbindir
    for i in java \
    policytool servertool pack200 unpack200
    do 
     	 [ -e "$i" ] && ln -s ../../bin/$i %buildroot%jrebindir/
    done
popd

install -dm 755 $RPM_BUILD_ROOT%{_jvmjardir}

# versionless symbolic links
pushd $RPM_BUILD_ROOT%{_jvmdir}
   ln -s %{jredir} %{jrelnk}
   ln -s %{sdkdir} %{sdklnk}
popd
pushd $RPM_BUILD_ROOT%{_jvmjardir}
   ln -s %{sdkdir} %{jrelnk}
   ln -s %{sdkdir} %{sdklnk}
popd

# classmap database directory
mkdir -p %buildroot%_libdir/gcj

# extensions handling
install -dm 755 $RPM_BUILD_ROOT%{jvmjardir}
for jarname in jaas jce jdbc-stdext jndi jndi-cos jndi-dns \
    jndi-ldap jndi-rmi jsse sasl
do
  rln %{_jvmdir}/%{jredir}/lib/$jarname.jar %{jvmjardir}/$jarname-%{version}.jar
done
pushd $RPM_BUILD_ROOT%{jvmjardir}
  for jar in *-%{version}.jar
  do
    ln -sf ${jar} $(echo $jar | sed "s|-%{version}.jar|-%{javaver}.jar|g")
    ln -sf ${jar} $(echo $jar | sed "s|-%{version}.jar|.jar|g")
  done
popd
#ln -s %jppname-%version %buildroot%{_jvmjardir}/%jppname

# amd64 compatibility link
%ifarch x86_64
pushd $RPM_BUILD_ROOT%{_jvmdir}/%{jredir}/lib
  ln -s %{_arch} amd64
popd
%endif

mkdir -p %buildroot%_altdir
# jre alternative
%__cat <<EOF >%buildroot%_altdir/%name-java
%{_bindir}/java	%{jrebindir}/java	%priority
%_man1dir/java.1.gz	%java_home/man/man1/java.1.gz	%{jrebindir}/java
EOF
# binaries and manuals
for i in keytool policytool servertool pack200 unpack200 \
orbd rmid rmiregistry tnameserv
do
  [ -L %buildroot%jrebindir"$i" ] || [ -e %buildroot%jrebindir"$i" ] && \
  %__cat <<EOF >>%buildroot%_altdir/%name-java
%_bindir/$i	%jrebindir/$i	%{jrebindir}/java
EOF
  [ -L %java_home/man/man1/$i.1.gz ] || [ -e %java_home/man/man1/$i.1.gz ] && \
  %__cat <<EOF >>%buildroot%_altdir/%name-java
%_man1dir/$i.1.gz	%java_home/man/man1/$i.1.gz	%{jrebindir}/java
EOF
done

# javac alternative and manual
cat <<EOF>%buildroot%_altdir/%name-javac
%_bindir/javac	%sdkbindir/javac	%priority
%_man1dir/javac.1.gz	%java_home/man/man1/javac.1.gz	%sdkbindir/javac
EOF
# binaries and manuals
for i in appletviewer extcheck idlj jar jarsigner javadoc javah javap jdb native2ascii rmic serialver apt jconsole jinfo jmap jps jsadebugd jstack jstat jstatd \
jhat jrunscript jvisualvm schemagen wsgen wsimport xjc \
HtmlConverter
do
  [ -L $RPM_BUILD_ROOT%sdkbindir/$i ] || [ -e $RPM_BUILD_ROOT%sdkbindir/$i ] && \
  %__cat <<EOF >>%buildroot%_altdir/%name-javac
%_bindir/$i	%sdkbindir/$i	%sdkbindir/javac
EOF
  [ -L $RPM_BUILD_ROOT%sdkbindir/$i ] || [ -e $RPM_BUILD_ROOT%java_home/man/man1/$i.1.gz ] && \
  %__cat <<EOF >>%buildroot%_altdir/%name-javac
%_man1dir/$i.1.gz	%java_home/man/man1/$i.1.gz	%sdkbindir/javac
EOF
done
# ----- JPackage compatibility alternatives ------
  %__cat <<EOF >>%buildroot%_altdir/%name-javac
%{_jvmdir}/java	%java_home	%sdkbindir/javac
%{_jvmdir}/java-%{origin}	%java_home	%sdkbindir/javac
%{_jvmdir}/java-%{javaver}	%java_home	%sdkbindir/javac
EOF


######## triggerin(jre) converted #############
%__cat <<EOF >>%buildroot%_altdir/%name-jaxp_parser_impl
%{_javadir}/jaxp_parser_impl.jar	%{_javadir}/libgcj-%__gcc_version_base.jar	20
EOF

# rt.jar
rln %{_javadir}/libgcj-%__gcc_version_base.jar %{_jvmdir}/%{sdkdir}/jre/lib/rt.jar
# libjawt.so
rln %_libdir/gcj-%__gcc_version_base/libjawt.so \
    %{_jvmdir}/%{jredir}/lib/%{_arch}/libjawt.so
# libjvm.so
rln %_libdir/gcj-%__gcc_version_base/libjvm.so \
    %{_jvmdir}/%{jredir}/lib/%{_arch}/client/libjvm.so
rln %_libdir/gcj-%__gcc_version_base/libjvm.so \
    %{_jvmdir}/%{jredir}/lib/%{_arch}/server/libjvm.so

######## triggerin(devel) converted #############
# tools.jar
rln %{_javadir}/libgcj-tools-%__gcc_version_base.jar \
    %{_jvmdir}/%{sdkdir}/lib/tools.jar

# create symbolic links to headers in gcj's versioned directory
for headername in jawt jni
do
  DIRECTORY=$(dirname $(gcj-%__gcc_version_base \
    -print-file-name=include/$headername.h))
  rln $DIRECTORY/$headername.h \
    %{_jvmdir}/%{sdkdir}/include/$headername.h
done
for headername in jawt_md jni_md
do
  DIRECTORY=$(dirname $(gcj-%__gcc_version_base \
    -print-file-name=include/$headername.h))
  rln $DIRECTORY/$headername.h \
    %{_jvmdir}/%{sdkdir}/include/linux/$headername.h
done
######## end triggerin converted #############

# versioned gcj-dbtool. hack not to depend on alternatives.
subst s,%_bindir/gcj-dbtool,%_bindir/%_target_platform-gcj-dbtool-%__gcc_version_base,g %buildroot%_bindir/rebuild-gcj-db

%post -n %jppname
%_bindir/rebuild-gcj-db ||:

%files
#%files -n %jppname-devel
%_altdir/%name-javac
%{_jvmdir}/%{sdklnk}
%java_home/include
%java_home/lib
%java_home/bin/javadoc

%files -n %jppname
%dir %java_home
# tmp hack until jre/bin will be filled properly
%exclude %java_home/bin/javadoc
%java_home/bin
%java_home/jre
%java_home/man
%{_jvmdir}/%{jrelnk}
%_altdir/%name-java
%_altdir/%name-jaxp_parser_impl
%dir %_libdir/gcj
%_bindir/rebuild-gcj-db
/usr/lib/rpm/rebuild-gcj-db.filetrigger
%_jvmjardir/%jppname
%_jvmjardir/%sdkdir
%_jvmjardir/jre-%{javaver}-%{origin}

%changelog
