Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-java
# END SourceDeps(oneline)
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
Name:           jetty-version-maven-plugin
Version:        1.0.7
Release:        alt4_13jpp8
Summary:        Jetty version management Maven plugin

License:        ASL 2.0 or EPL
URL:            http://www.eclipse.org/jetty/
Source0:        http://git.eclipse.org/c/jetty/org.eclipse.jetty.toolchain.git/snapshot/%{name}-%{version}.tar.bz2
BuildArch:      noarch

BuildRequires:  maven-local
BuildRequires:  mvn(org.apache.commons:commons-lang3)
BuildRequires:  mvn(org.apache.maven:maven-plugin-api)
BuildRequires:  mvn(org.apache.maven:maven-project)
BuildRequires:  mvn(org.eclipse.jetty.toolchain:jetty-toolchain:pom:)
Source44: import.info


%description
Jetty version management Maven plugin

%package        javadoc
Group: Development/Java
Summary:        API documentation for %{name}
BuildArch: noarch

%description    javadoc
%{summary}.


%prep
%setup -q
# copy license files
cp -p jetty-distribution-remote-resources/src/main/resources/* .

# we have java.util stuff in JVM directly now
# https://bugs.eclipse.org/bugs/show_bug.cgi?id=401163
sed -i 's|edu.emory.mathcs.backport.||' \
    jetty-version-maven-plugin/src/main/java/org/eclipse/jetty/toolchain/version/Release.java

%build
pushd %{name}
# skip tests because we don't have jetty-test-helper (yet)
%mvn_build -f

%install
pushd %{name}
%mvn_install


%files -f %{name}/.mfiles
%dir %{_javadir}/%{name}
%doc LICENSE-APACHE-2.0.txt LICENSE-ECLIPSE-1.0.html notice.html

%files javadoc -f %{name}/.mfiles-javadoc
%doc LICENSE-APACHE-2.0.txt LICENSE-ECLIPSE-1.0.html notice.html

%changelog
