Epoch: 0
Group: Development/Java
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# %%name or %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name jmock
%define version 2.8.1
%global namedreltag %{nil}
%global namedversion %{version}%{?namedreltag}

Name:          jmock
Version:       2.8.1
Release:       alt1_2jpp8
Summary:       Java library for testing code with mock objects
License:       BSD
Url:           http://www.jmock.org/
Source0:       https://github.com/jmock-developers/jmock-library/archive/%{namedversion}.tar.gz

BuildRequires: maven-local
BuildRequires: mvn(cglib:cglib)
BuildRequires: mvn(junit:junit)
BuildRequires: mvn(org.apache.maven.plugins:maven-dependency-plugin)
BuildRequires: mvn(org.beanshell:bsh)
BuildRequires: mvn(org.codehaus.mojo:exec-maven-plugin)
BuildRequires: mvn(org.hamcrest:hamcrest-library)
BuildRequires: mvn(org.objenesis:objenesis)
BuildRequires: mvn(org.ow2.asm:asm)
BuildRequires: mvn(org.sonatype.oss:oss-parent:pom:)

BuildArch:     noarch
Source44: import.info

%description
Mock objects help you design and test the interactions between the objects in
your programs.
The jMock library:
  * makes it quick and easy to define mock objects, so you don't break the
    rhythm of programming.
  * lets you precisely specify the interactions between your objects, reducing
    the brittleness of your tests.
  * works well with the auto-completion and re-factoring features of your IDE
  * plugs into your favorite test framework
  * is easy to extend.

%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.

%prep
%setup -q -n %{name}-library-%{namedversion}

%pom_remove_plugin :nexus-staging-maven-plugin
%pom_remove_plugin :maven-javadoc-plugin
%pom_remove_plugin :maven-source-plugin

%pom_remove_plugin :maven-gpg-plugin testjar

%pom_xpath_set "pom:dependency[pom:groupId = 'cglib' ]/pom:artifactId" cglib
%pom_xpath_set "pom:dependency[pom:groupId = 'cglib' ]/pom:artifactId" cglib %{name}

sed -i "s|%classpath|$(build-classpath objectweb-asm/asm)|" %{name}/pom.xml

%pom_xpath_remove pom:build %{name}-example
%pom_xpath_inject "pom:project" "
<build>
  <sourceDirectory>src/main</sourceDirectory>
</build>" %{name}-example
# package org.jmock.integration.junit{3,4} do not exist
%pom_add_dep org.%{name}:%{name}-junit3:'${project.version}' %{name}-example
%pom_add_dep org.%{name}:%{name}-junit4:'${project.version}' %{name}-example

%mvn_alias org.%{name}:%{name} :%{name}-script
%mvn_package org.%{name}:%{name}::tests:
%mvn_package org.%{name}:%{name}-junit3::tests:

%build

%mvn_build

%install
%mvn_install

%files -f .mfiles
%doc README*
%doc LICENSE.txt

%files javadoc -f .mfiles-javadoc
%doc LICENSE.txt

%changelog
