Epoch: 0
Group: Development/Java
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
%global tzversion tzdata2015e

Name:             joda-time
Version:          2.8.1
Release:          alt1_1.tzdata2015ejpp8
Summary:          Java date and time API

License:          ASL 2.0
URL:              http://www.joda.org/joda-time/
Source0:          https://github.com/JodaOrg/%{name}/archive/v%{version}.tar.gz
Source1:          ftp://ftp.iana.org/tz/releases/%{tzversion}.tar.gz
BuildArch:        noarch

BuildRequires:    maven-local
BuildRequires:    joda-convert
BuildRequires:    exec-maven-plugin
Source44: import.info


%description
Joda-Time provides a quality replacement for the Java date and time classes. The
design allows for multiple calendar systems, while still providing a simple API.
The 'default' calendar is the ISO8601 standard which is used by XML. The
Gregorian, Julian, Buddhist, Coptic, Ethiopic and Islamic systems are also
included, and we welcome further additions. Supporting classes include time
zone, duration, format and parsing.


%package javadoc
Group: Development/Java
Summary:          Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.


%prep
%setup -q

sed -i 's/\r//' LICENSE.txt
sed -i 's/\r//' NOTICE.txt
sed -i 's/\r//' RELEASE-NOTES.txt

# all java binaries must be removed from the sources
find . -name '*.jar' -exec rm -f '{}' \;

# replace internal tzdata
rm -f src/main/java/org/joda/time/tz/src/*
tar -xzf %{SOURCE1} -C src/main/java/org/joda/time/tz/src/

# compat filename
%mvn_file : %{name}

# javadoc generation fails due to strict doclint in JDK 8
%pom_remove_plugin :maven-javadoc-plugin

%build
%mvn_build

%install
%mvn_install

%files -f .mfiles
%doc LICENSE.txt RELEASE-NOTES.txt NOTICE.txt

%files javadoc -f .mfiles-javadoc
%doc LICENSE.txt NOTICE.txt

%changelog
