# -*- rpm-spec -*-

Name: jpilot
Summary: Palm pilot desktop for Linux
Summary(ru_RU.KOI8-R): Palm pilot desktop  Linux
Version: 0.99.9
Release: alt7.qa5

Packager: Pavlov Konstantin <thresh@altlinux.ru>

License: GPL
Group: Communications
Url: http://www.jpilot.org
Source: %name-%{version}.tar
Source1: jpilot-icons.tar
Source2: jpilot-ru.po
Source3: mkinstalldirs
Requires: pilot-link >= 0.12.1-alt1

Patch0: jpilot-0.99.8-alt-fixes.patch
Patch1: jpilot-0.99.8-1-alt-fixes.patch
#Patch2: %name-0.99.8-alt-gettext.patch
Patch2: jpilot-0.99.9pre2-alt-gettext.patch
Patch3: jpilot-0.99.8-sync.patch
Patch4: jpilot-0.99.9-keyring.patch
#Patch5: jpilot-0.99.9-keyring-br.patch
Patch6: jpilot-0.99.9-configure-lib64.patch

BuildRequires: libpilot-link-devel >= 0.12.1-alt1

BuildRequires: fontconfig freetype2 gcc-c++ glib2-devel intltool libatk-devel
BuildRequires: libcairo-devel libg2c-devel libgtk+2-devel libpango-devel
BuildRequires: libssl-devel libstdc++-devel perl-XML-Parser pkgconfig

%description
J-Pilot is a desktop organizer application for the palm pilot that runs
under Linux and UNIX.  It is similar in functionality to the one that 3com
distributes for a well known rampant legacy operating system.

%description -l ru_RU.KOI8-R
J-Pilot -    Palm pilot,    Linux  UNIX.
     ,  3com  
   .

%package plugins-devel
Summary: Library and header file needed for jpilot plugin development
Group: Communications
Requires: %name = %version-%release

%description plugins-devel
J-Pilot is a desktop organizer application for the palm pilot that runs
under Linux and UNIX.  It is similar in functionality to the one that 3com
distributes for a well known rampant legacy operating system.

The library and header file required for plugin development

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
#%patch3 -p0
%patch4 -p0
#%patch5 -p0
%patch6 -p1

cp %SOURCE2 po/ru.po
cp %SOURCE3 .
chmod +x mkinstalldirs

%build
NOCONFIGURE=1 ./autogen.sh
export ABILIB=%_lib
%configure \
	--enable-stock-buttons \
	--libdir=%_libdir/jpilot

%make_build

%install
install -d %buildroot/{%_mandir/man1,%_bindir}
%makeinstall

install -d html
install docs/*.html docs/*.png html

install -d %buildroot%_datadir/%name
install jpilotrc.* %buildroot%_datadir/%name
install empty/*.pdb %buildroot%_datadir/%name

install -m 644 {libplugin,prefs}.h %buildroot%_libdir/jpilot/plugins/

tar xvf %SOURCE1
install -D -m644 jpilot.xpm %buildroot/%_niconsdir/jpilot.xpm
install -D -m644 mini/jpilot.xpm %buildroot/%_miconsdir/jpilot.xpm
install -D -m644 large/jpilot.xpm %buildroot/%_liconsdir/jpilot.xpm

if grep '^Categories=Application;Office;$' %buildroot%_desktopdir/jpilot.desktop; then
    cat > %buildroot%_desktopdir/jpilot.desktop <<EOF
[Desktop Entry]
Name=J-Pilot
Comment=Desktop organizer application for the Palm Pilot
Exec=jpilot
Icon=jpilot
Terminal=false
Type=Application
Categories=Office;PDA;
EOF
    else
	echo "desktop above is deprecated. PLEASE, merge Categories to the new upstream desktop file"
	exit 1
fi

# Fix jpilot doc bug
rm -rf %buildroot/usr/doc

rm -f %buildroot%_libdir/%name/plugins/*.la

%find_lang %name

%files -f %name.lang
#%doc AUTHORS BUGS ChangeLog INSTALL README TODO html
%_bindir/*
%_datadir/jpilot/jpilotrc.*
%_datadir/jpilot/*.pdb
%_miconsdir/*xpm
%_niconsdir/*xpm
%_liconsdir/*xpm
%_datadir/applications/*
%dir %_datadir/jpilot
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/*.so*
%_mandir/man1/*
%_datadir/doc/%name-%version

%files plugins-devel
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%_libdir/jpilot/plugins/libplugin.h
%_libdir/jpilot/plugins/prefs.h

%changelog
