%undefine __libtoolize
%define _keep_libtool_files 1
%define _optlevel s

%define qtdir %_qt3dir
%define kdedir %_K3prefix

%def_with gstreamer

Name: kaffeine
Version: 0.8.8
%define beta %nil
Release: alt10

Group: Video
Summary: A Xine-based Media Player for KDE
License: GPL
Url: http://kaffeine.sourceforge.net/

Source: %name-%version%beta.tar.bz2
# FC
Patch1: acinclude.patch
# ALT
Patch2: kaffeine-0.8.4-alt-ru.patch
Patch3: kaffeine-0.8.4-alt-without-xcb.patch
Patch4: kaffeine-0.8.7-alt-desktop.patch
Patch5: kaffeine-0.8.7-alt-i18n-ru-servicemenus.patch
Patch6: kaffeine-0.8.7-alt-dont-replace-percent.patch
Patch7: kaffeine-0.8.8-alt-fix-compile.patch
Patch8: kaffeine-0.8.8-alt-automake.patch
Patch9: tde-3.5.13-build-defdir-autotool.patch
Patch10: kaffeine-0.8.8-mp3InputPlugBuild.patch

# Automatically added by buildreq on Tue Jun 23 2009 (-bi)
#BuildRequires: doxygen gcc-c++ gcc-fortran graphviz gst-plugins-devel imake kdepim-devel libXt-devel libXtst-devel libcdio-devel libjpeg-devel liblame-devel libxine-devel qt3-designer qt3-doc-html rpm-build-ruby xml-utils xorg-cf-files xorg-inputproto-devel
BuildRequires(pre): kdelibs-devel
BuildRequires: doxygen gcc-c++ graphviz kdelibs-devel libpng-devel
BuildRequires: libcdio-paranoia-devel libjpeg-devel liblame-devel libxine-devel xml-utils
%if_with gstreamer
BuildRequires: gst-plugins-devel
%endif

%description
Kaffeine is a Xine-based Media Player for QT/KDE

%package -n lib%{name}
Group: System/Libraries
Summary: Base libraries for %name
Requires: kdelibs
Conflicts: kaffeine < 0.8
%description -n lib%{name}
Base libraries for %name

%package -n lib%{name}-devel
Group: Development/KDE and QT
Summary: Headers and development files for lib%{name}
Requires: lib%{name} = %EVR
%description -n lib%{name}-devel
Headers and development files for lib%{name}

%package -n kde3-kaffeine
Group: Video
Summary: A Xine-based Media Player for KDE
Provides: kaffeine = %version-%release
Obsoletes: kaffeine < %version-%release
Requires: kde3-kaffeine-engine >= %version-%release
%description -n kde3-kaffeine
Kaffeine is a Xine-based Media Player for QT/KDE

%package -n kde3-kaffeine-engine-xine
Group: Video
Summary: Kaffeine Xine player part
Provides: kde3-kaffeine-engine = %version-%release
Obsoletes: kaffeine-engine-xine < %version-%release
Conflicts: kaffeine <= 0.8.5-alt3
%description -n kde3-kaffeine-engine-xine
A Kaffeine engine based on xine.

%package -n kde3-kaffeine-engine-gstreamer
Group: Video
Summary: Kaffeine GStreamer player part
Provides: kde3-kaffeine-engine = %version-%release
Obsoletes: kaffeine-engine-gstreamer < %version-%release
Requires: gst-ffmpeg gst-plugins-alsa gst-plugins-base-audio-filters gst-plugins-base-video-filters
Requires: gst-plugins-good-audio-formats gst-plugins-good-container-formats gst-plugins-good-tags
Requires: gst-plugins-good-video-filters gst-plugins-lame gst-plugins-mad gst-plugins-ogg
Requires: gst-plugins-theora gst-plugins-vorbis gst-plugins-xvideo
%description -n kde3-kaffeine-engine-gstreamer
A Kaffeine engine based on GStreamer.

%prep
%setup -q -n %name-%version%beta
#%patch1 -p0
%patch2 -p1
#%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
#%patch8 -p1
%patch9
%patch10 -p1

cp -Rp /usr/share/libtool/aclocal/libtool.m4 admin/libtool.m4.in
cp -Rp /usr/share/libtool/config/ltmain.sh admin/ltmain.sh
make -f admin/Makefile.common

%build
rm -rf %buildroot
export QTDIR=%qtdir
export KDEDIR=%prefix
export PATH=%qtdir/bin:%kdedir/bin:$PATH
%K3configure \
    --disable-debug \
    %{subst_with gstreamer} \
    --disable-gcc-hidden-visibility \
    --with-xinerama
#    --without-xcb \
#    --with-xinit-workaround \

%make_build

%install
%K3install PACKAGE=%name

%K3find_lang --with-man --with-kde %name

%files -n lib%{name}
%_K3libdir/lib*%{name}*.so*

%files -n lib%{name}-devel
%_K3libdir/lib*%{name}*.la
%_K3lib/libxinepart.la
%_K3lib/lib*%{name}*.la
%_K3includedir/%{name}*

%files -n kde3-kaffeine -f %name.lang
%doc AUTHORS ChangeLog README TODO kaffeine/README.* kaffeine/CREDITS kaffeine/BUGS
#%_man1dir/*
#
%_K3bindir/%name
%_K3lib/lib*%{name}*.so*
#
%_K3xdg_apps/%name.desktop
%_K3mimelnk/application/*%{name}*.desktop
%_K3srv/*%{name}*.desktop
%_K3srvtyp/*%{name}*.desktop
#
%_K3apps/%name
%exclude %_K3apps/%name/xine_part.rc
%_K3apps/profiles/*
%_K3apps/konqueror/servicemenus/*.desktop
#
%_kde3_iconsdir/hicolor/*/apps/*.png
%_kde3_iconsdir/*/*/actions/*.png
%_kde3_iconsdir/*/*/mimetypes/*%{name}*.png

%files -n kde3-kaffeine-engine-xine
%_K3lib/libxinepart.so*
%_K3apps/%name/xine_part.rc
%_K3srv/xine_part.desktop

%if_with gstreamer
%files -n kde3-kaffeine-engine-gstreamer
%_K3lib/libgstreamerpart.so*
%_K3apps/gstreamerpart
%_K3srv/gstreamer_part.desktop
%endif

%changelog
