# $Id: kannel.spec 2836 2005-01-17 11:53:55Z dude $
# Authority: matthias

%define branch meta-data
%define kannel_user kannel
%define kannel_group kannel
%define cvs_build 20091101

Summary: WAP and SMS gateway
Name: kannel
Version: 1.5.0
Release: alt1.cvs%cvs_build.1.qa1
License: Kannel
Group: Communications
URL: http://www.kannel.org/
Source: gateway-%version.tar.bz2
Source1: bearerbox.init
Source2: smsbox.init
Source3: kannel.logrotate
Source4: kannel.monit
Patch0: kannel-1.4.1-alt-rm_enquire_link.patch
Patch1: kannel_store_tools.patch
Patch2: kannel-dlr-retry.patch
Patch3: kannel-pam.patch

PreReq: monit-base
BuildPreReq: linux-libc-headers openssl-engines 

Packager: Michael Bochkaryov <misha@altlinux.ru>

# Automatically added by buildreq on Wed Nov 11 2009 (-bi)
BuildRequires: ImageMagick-tools flex libMySQL-devel libpam-devel libpcre-devel libsqlite3-devel libxml2-devel openssl postgresql-devel sqlite3 

%description
Kannel is an open source software implementing the following functionality:

* WAP gateway for connecting WAP (Wireless Application Protocol) capable
phones to the Internet. WML and WMLScript files compilation to binary
form is supported.

* SMS gateway for implementing services based on GSM/CDMA short messages.
GSM modems, SMPP, UCP/EMI, CIMD and other SMSC connections are supported.

* WAP Push Proxy Gateway (PPG).

* OTA Settings delivery platform.

Compiled with PAM, SSL, MySQL, PostgreSQL, SQLite3 and native malloc.

%package devel
Summary: Development files for the kannel WAP and SMS gateway
Group: Development/C
Requires: %name = %version

%description devel
This package contains libraries and header files for Kannel WAP and SMS
gateway. Install this package if you need to develop or recompile
applications that use Kannel.

%prep
%setup -n gateway-%version
%patch0 -p2
%patch1 -p0
%patch2 -p0
%patch3 -p0

%build
%configure \
		--with-cflags='-fPIC' \
		--enable-cookies \
		--enable-largefile \
		--disable-docs \
		--disable-drafts \
		--enable-keepalive \
		--disable-mutex-stats \
		--enable-localtime \
		--enable-pam \
		--enable-pcre \
		--enable-sms \
		--enable-ssl \
		--disable-start-stop-daemon \
		--with-defaults=speed \
		--enable-wap \
		--with-mysql \
		--with-pgsql \
		--without-sqlite \
		--with-sqlite3 \
		--with-ssl=%_libdir/openssl \
		--disable-ssl-thread-test
%make

%install
%makeinstall

%make_install install-docs DESTDIR=%buildroot
#mv %%buildroot%%_datadir/doc/kannel _docs

mkdir -p %buildroot%_sysconfdir/kannel
mkdir -p %buildroot%_sysconfdir/logrotate.d
mkdir -p %buildroot%_sysconfdir/monitrc.d
mkdir -p %buildroot%_initdir
mkdir -p %buildroot%_logdir/kannel
mkdir -p %buildroot%_localstatedir/kannel
mkdir -p %buildroot%_var/run/kannel
install -m 644 gw/wapkannel.conf %buildroot%_sysconfdir/kannel
install -m 644 gw/smskannel.conf %buildroot%_sysconfdir/kannel
install -m 755 test/fakesmsc %buildroot%_bindir
install -m 755 test/fakewap %buildroot%_bindir
install -m 755 test/store_tools %buildroot%_bindir/kannel_store_tools
install -m 755 test/wapproxy %buildroot%_bindir
install -m 755 %SOURCE1 %buildroot%_initdir/kannel.bearerbox
install -m 755 %SOURCE2 %buildroot%_initdir/kannel.smsbox
install -m 755 %SOURCE3 %buildroot%_sysconfdir/logrotate.d/kannel
install -m 755 %SOURCE4 %buildroot%_sysconfdir/monitrc.d/kannel


%pre
%_sbindir/groupadd %kannel_group ||:
%_sbindir/useradd -r -d /dev/null -s /dev/null -g %kannel_group -n %kannel_user \
	2> /dev/null > /dev/null ||:

%post
%post_service kannel.bearerbox
%post_service kannel.smsbox
                                                                                
%preun
%preun_service kannel.smsbox
%preun_service kannel.bearerbox
                                                                                
%files
%doc AUTHORS COPYING ChangeLog NEWS README STATUS contrib
#%%doc _docs/*  
%_bindir/*
%_sbindir/*
#%%exclude %%_sbindir/start-stop-daemon
%_mandir/man?/*
%dir %_sysconfdir/kannel
%config(noreplace) %_sysconfdir/kannel/*
%config(noreplace) %_sysconfdir/monitrc.d/*
%config(noreplace) %_sysconfdir/logrotate.d/*
%_initdir/*
%attr(0770,%kannel_user,%kannel_group) %dir %_logdir/kannel
%attr(0770,%kannel_user,%kannel_group) %dir %_var/run/kannel
%attr(0770,%kannel_user,%kannel_group) %dir %_localstatedir/kannel

%files devel
%_includedir/kannel/
%dir %_libdir/kannel/
%_libdir/kannel/*.a

%changelog
