%def_disable shared
%def_enable static
%def_disable rpath
%def_disable debug
%def_without arts

%define Name Kile
%define oname kile
Name: kde3-kile
Version: 2.0.3
%define prerel %nil
Release: alt3
Summary: LaTeX source editor - TeX shell
Group: Publishing
License: %gpl2plus
URL: http://%name.sourceforge.net
Source: %oname-%version%prerel.tar
Patch: %oname-%version-%release.patch
Packager: Evgeny Sinelnikov <sin@altlinux.ru>

Requires: libkbibtexpart3
Requires: kdegraphics-kghostview kdegraphics-kpdf kdegraphics-kview kdegraphics-kdvi
Requires: %_bindir/asy %_bindir/convert %_bindir/dblatex
Requires: %_bindir/bibtex %_bindir/dvipdfm %_bindir/dvipng
Requires: %_bindir/dvips %_bindir/latex %_bindir/latex2html
Requires: %_bindir/lilypond %_bindir/makeindex %_bindir/mpost
Requires: %_bindir/pdflatex %_bindir/pdftex %_bindir/ps2pdf
Requires: %_bindir/tex

BuildRequires(pre): rpm-build-licenses
BuildRequires: doxygen gcc-c++ imake kdelibs-devel libdnet-devel
BuildRequires: libXt-devel libjpeg-devel xml-utils xorg-cf-files

Conflicts: kile >= 2.1
Conflicts: kde4-kile

%description
%Name is a program for KDE 3, that integrates many tools needed to
develop documents with LaTeX, in just one application.


%prep
%setup -n %oname-%version%prerel
%patch -p1


%build
sh admin/cvs.sh dist
%configure \
    %{subst_enable rpath} \
    %{subst_enable shared} \
    %{subst_enable static} \
    %{subst_with   arts} \
%if_enabled debug
    --enable_debug=full
%else
    --disable-debug
%endif

%make_build

bzip2 --best --keep --force ChangeLog

%install
%make_install DESTDIR=%buildroot install

mkdir -p %buildroot%_docdir/%oname-%version
install AUTHORS ChangeLog.* README README.cwl TODO %oname-remote-control.txt \
    %buildroot%_docdir/%oname-%version/

%find_lang --with-kde %oname


%files -f %oname.lang
#doc AUTHORS ChangeLog.* README README.cwl TODO %oname-remote-control.txt
%_docdir/%oname-%version
%_bindir/*
%_iconsdir/hicolor/*/*/*.png
%_iconsdir/hicolor/scalable/apps/*
%_datadir/applications/kde/*
%_datadir/apps/%oname
%_datadir/apps/kconf_update/*
%_datadir/config.kcfg/*
%_datadir/mimelnk/text/x-%{oname}*


%changelog
