%define _kde_alternate_placement 1
%add_findpackage_path %_kde4_bindir

%define rname kdeaccessibility
Name: kde4accessibility
%define major 15
%define minor 08
%define bugfix 2
Version: %major.%minor.%bugfix
Release: alt1


Group: Graphical desktop/KDE
Summary: K Desktop Environment - Accessibility program
Url: http://www.kde.org
License: GPL

Requires: %name-jovie = %version-%release
Requires: %name-kaccessible = %version-%release
Requires: %name-kmag = %version-%release
Requires: %name-kmousetool = %version-%release
Requires: %name-kmouth = %version-%release

Source0: jovie-%version.tar
Source1: kaccessible-%version.tar
Source2: kmag-%version.tar
Source3: kmousetool-%version.tar
Source4: kmouth-%version.tar
Patch1: jovie-4.10.3-alt-fix-build.patch

# Automatically added by buildreq on Wed Oct 22 2008 (-bi)
#BuildRequires: festival flite gcc-c++ kde4base-runtime-devel kde4base-workspace-devel libXScrnSaver-devel libXcomposite-devel libXdamage-devel libXft-devel libXpm-devel libXt-devel libXtst-devel libXv-devel libXxf86misc-devel libalsa-devel libxkbfile-devel rpm-build-ruby xorg-xf86vidmodeproto-devel
#BuildRequires: festival flite
BuildRequires(pre): kde4base-workspace-devel
BuildRequires: gcc-c++ libalsa-devel libspeechd-devel libqaccessibilityclient-devel
BuildRequires: kde4base-runtime-devel kde4base-workspace-devel

%description
KDE Accessibility Aids:
- kmag, a screen magnifier,
- kmousetool, a program for people whom it hurts to click the mouse
- KMouth, a program that allows people who have lost their voice to let
  their computer speak for them.


%package common
Summary: %name common package
Group: System/Configuration/Other
Requires: kde-common >= %major.%minor
%description common
%name common package

%package core
Summary: Core files for %name
Group: Graphical desktop/KDE
Requires: %name-common = %version-%release
%description core
Core files for %name

%package kaccessible
Group: Graphical desktop/KDE
Summary: KDE accessibility services
Requires: %name-core = %version-%release
%description kaccessible
kaccessible implements a QAccessibleBridgePlugin to provide accessibility services like
focus tracking and a screenreader

%package kmag
Group: Graphical desktop/KDE
Summary: KMag Program
Requires: %name-core = %version-%release
%description kmag
KMag Program

%package kmouth
Group: Graphical desktop/KDE
Summary: KMag Program
Requires: %name-core = %version-%release
%description kmouth
Kmouth Program

%package kmousetool
Group: Graphical desktop/KDE
Summary: kmousetool program
Requires: %name-core = %version-%release
%description kmousetool
kmousetool program

%package -n libkttsd4
Summary: KDE 4 library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkttsd4
KDE 4 library.

%package jovie
Group: Graphical desktop/KDE
Summary: KTTS - KDE Text-to-Speech
Requires: %name-core = %version-%release
Provides: %name-kttsd = %version-%release
Obsoletes: %name-kttsd < %version-%release
%description jovie
KTTS -- KDE Text-to-Speech -- is a subsystem within the KDE desktop for
conversion of text to audible speech. KTTS is currently under development
and aims to become the standard subsystem for all KDE applications
to provide speech output.
User Features:
 - Speak any text from the KDE clipboard.
 - Speak any plain text file.
 - Speak all or any portion of a text file from Kate.
 - Speak all or any portion of an HTML page from Konqueror.
 - Use as the speech backend for KMouth and KSayIt.
 - Speak KDE notifications (KNotify).
 - Long text is parsed into sentences. User may backup by sentence or
   paragraph, replay, pause, and stop playing.
 - Audio output via aRts, ALSA, GStreamer (version 0.8.7 or later), or aKode.

%package devel
Group: Development/KDE and Qt
Summary: Header files for developing kaccessibility utils
Requires: %name-common = %version-%release
%description devel
Header files needed for developing ktts applications.


%prep
%setup -q -cT -n %rname-%version -a0 -a1 -a2 -a3 -a4
pushd jovie-*
%patch1 -p1
popd

ls -d1 * | \
while read d
do
    [ "$d" == "${d#lib}" ] || continue
    [ -d "$d" ] || continue
    echo "add_subdirectory($d)" >> CMakeLists.txt
done


%build
%K4build


%install
%K4install


%files
%files common

%files core
#%_kde4_iconsdir/hicolor/*/actions/followmouse.*
#%_kde4_iconsdir/hicolor/*/actions/hidemouse.*
#%_kde4_iconsdir/hicolor/*/actions/window.*
%_kde4_iconsdir/hicolor/*/actions/speak.*
%_kde4_iconsdir/hicolor/*/actions/nospeak.*
%_kde4_iconsdir/hicolor/*/actions/female.png
%_kde4_iconsdir/hicolor/*/actions/male.png

%files kaccessible
%doc kaccessible*/README
%_K4exec/kaccessibleapp
%_K4lib/plugins/accessiblebridge/kaccessiblebridge.so
%_K4dbus_services/org.kde.kaccessible.service

%files kmag
%_kde4_bindir/kmag
%_kde4_xdg_apps/kmag.desktop
%_kde4_iconsdir/hicolor/*/apps/kmag.*
%_K4apps/kmag
%_K4doc/en/kmag

%files kmouth
%_kde4_bindir/kmouth
%_kde4_xdg_apps/kmouth.desktop
%_K4apps/kmouth
%_K4conf/kmouthrc
%_kde4_iconsdir/hicolor/*/apps/kmouth.png
%_K4doc/en/kmouth

%files kmousetool
%_kde4_bindir/kmousetool
%_kde4_xdg_apps/kmousetool.desktop
%_K4apps/kmousetool
%_kde4_iconsdir/hicolor/*/*/kmousetool*.*
%_K4doc/en/kmousetool

%files jovie
%_kde4_bindir/jovie
%_K4lib/jovie_xmltransformerplugin.so
%_K4lib/jovie_talkerchooserplugin.so
%_K4lib/jovie_stringreplacerplugin.so
%_K4lib/kcm_kttsd.so
%_kde4_xdg_apps/jovieapp.desktop
%_K4apps/jovie
#%_K4apps/kttsd
%_K4srv/jovie_talkerchooserplugin.desktop
%_K4srv/jovie.desktop
%_K4srv/jovie_stringreplacerplugin.desktop
%_K4srv/jovie_xmltransformerplugin.desktop
%_K4srv/kcmkttsd.desktop
%_K4srv/kttsd.desktop
%_K4srvtyp/jovie_filterplugin.desktop
%_K4doc/en/jovie

%files -n libkttsd4
%_K4libdir/libkttsd.so.*

#%files devel
#%_K4link/*.so

%changelog
