
%add_findpackage_path %_kde4_bindir

%if_enabled kde_desktop
%def_disable desktop
%else
%def_enable desktop
%endif
%def_disable knewsticker

%define rname kdenetwork
%define major 15
%define minor 12
%define bugfix 1
Name: kde4network
Version: %major.%minor.%bugfix
Release: alt2

Packager: Sergey V Turchin <zerg at altlinux dot org>

Group: Graphical desktop/KDE
Summary: K Desktop Environment - Network Applications
License: GPL
Url: http://www.kde.org

Requires: %name-filesharing
Requires: %name-kdnssd
%if_enabled knewsticker
Requires: %name-knewsticker
%endif
Requires: %name-kget
Requires: kde4-kopete
Requires: %name-kppp
Requires: %name-krdc
Requires: %name-krfb

Source: ftp://ftp.kde.org/pub/kde/stable/%version/src/%rname-%version.tar
# FC
# ALT
Patch11: kdenetwork-4.7.1-alt-kget-newtransfer-dialog-size.patch
Patch12: kdenetwork-4.1.96-alt-find-decibel.patch
Patch13: kdenetwork-4.2.96-alt-zeroconf-autonet.patch
Patch14: kdenetwork-4.3.0-alt-def-kppp.patch
Patch15: kdenetwork-4.3.0-alt-kppp-var-lock.patch
Patch16: kdenetwork-4.6.0-alt-kppp-add-devices.patch
Patch17: kdenetwork-4.3.0-alt-kppp-search.patch
Patch18: kdenetwork-4.8.0-alt-kppp-select-modem.patch
Patch19: kdenetwork-4.3.0-alt-kppp-resolv-mods.patch
Patch20: kdenetwork-4.5.0-alt-kget-disable-bt.patch
Patch21: kdenetwork-4.7.1-alt-fix-compile.patch
Patch22: kdenetwork-4.5.1-alt-kppp-fix-statglg-close.patch
Patch23: kdenetwork-4.10.2-alt-samba-sharing.patch

BuildRequires(pre): kde4libs-devel
BuildRequires: gcc-c++ libqca2-devel libgmp-devel
BuildRequires: libvncserver-devel libgpgme-devel libexpat-devel
#BuildRequires: soprano soprano-backend-redland libsoprano-devel
#BuildRequires: soprano-backend-redland soprano-backend-virtuoso soprano
BuildRequires: libortp-devel >= 0.13
BuildRequires: libspeex-devel libalsa-devel libssl-devel
BuildRequires: libmediastreamer-devel
BuildRequires: libmediastreamer-ilbc
BuildRequires: libsrtp
BuildRequires: libfreerdp-devel
BuildRequires: libsqlite3-devel libidn-devel boost-devel libopenslp-devel libjasper-devel
BuildRequires: libqimageblitz-devel libxml2-devel libxslt-devel libmms-devel
BuildRequires: libjpeg-devel libavahi-qt4-devel bzlib-devel libldap-devel
BuildRequires: libgadu-devel libgnutls-devel libtasn1-devel
BuildRequires: rpm-macros-browser-plugins
BuildRequires: libktorrent-devel
BuildRequires: kde4libs-devel kde4pimlibs-devel
BuildRequires: kde4base-workspace-devel kde4base-devel
BuildRequires: shared-desktop-ontologies-devel
BuildRequires: libtelepathy-qt4-devel kde4-ktp-common-internals-devel

%description
Networking applications for the K Desktop Environment.

- kppp: Dual-up tool
%if_enabled knewsticker
- knewsticker: RDF newsticker applet
%endif
- krfb: Desktop Sharing server, allow others to access your desktop via VNC
- krdc: a client for Desktop Sharing and other VNC servers


%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kde-common >= 4
Conflicts: kdenetwork-common <= 3.5.12-alt1
%description common
%name common package

%package core
Summary: Core files for %name
Group: Graphical desktop/KDE
Requires: %name-common = %version-%release
%description core
Core files for %name

%package filesharing
Summary: %name filesharing
Group: Networking/File transfer
Requires: %name-core = %version-%release
%description filesharing
%name filesharing.

%package kdnssd
Summary: %name kdnssd
Group: Networking/Remote access
Requires: %name-core = %version-%release
Requires: avahi-daemon libnss-mdns
%description kdnssd
%name kdnssd.

%package knewsticker
Summary: %name knewsticker
Group: Networking/News
Requires: %name-core = %version-%release
%description knewsticker
%name knewsticker.

%package kget
Summary: %name kget
Group: Graphical desktop/KDE
Requires: %name-core = %version-%release
%description kget
%name kget.

%package -n libkget4
Summary: %name library
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkget4
%name library

%package -n libkrdccore4
Summary: %name libraries
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkrdccore4
%name library

%package kppp
Summary: %name kppp
Group: Networking/Remote access
Requires: %name-core = %version-%release
%description kppp
%name kppp.

%package krdc
Summary: %name krdc
Group: Networking/Remote access
Requires: %name-core = %version-%release
Requires: xfreerdp freerdp-plugins-standard
%description krdc
%name krdc.

%package -n libkrfbprivate4
Summary: %name libraries
Group: System/Libraries
Requires: %name-common = %version-%release
%description -n libkrfbprivate4
%name library

%package krfb
Summary: %name krfb
Group: Networking/Remote access
Requires: %name-core = %version-%release
%description krfb
%name krfb.

%package devel
Summary: Devel stuff for %name
Group: Development/KDE and QT
Requires: kde4libs-devel kde4-kopete-devel
Requires: %name-common = %version-%release
%description devel
This package contains header files needed if you wish to build applications
based on %name.


%prep
%setup -q -n %rname-%version
%patch11 -p1
#%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
#%patch20 -p1
#%patch21 -p1
%patch22 -p1
%patch23 -p0


%build
ls -d1 * | \
while read d
do
    [ -d "$d" ] || continue
    [ "$d" != "altlinux" ] || continue
    pushd $d
%K4cmake \
    -DKDE4_ENABLE_FPIE:BOOL=ON \
    -DMOZPLUGIN_INSTALL_DIR:PATH=%browser_plugins_path \
    -DSAMBA_PACKAGE_NAME=\\\"samba\\\" \
    -DENABLE_EMBEDDED_TORRENT_SUPPORT=false
#    -DKDE4_ENABLE_FINAL:BOOL=ON \
%K4make
    popd
done

%install
ls -d1 * | \
while read d
do
    [ -d "$d" ] || continue
    [ "$d" != "altlinux" ] || continue
    pushd $d
%K4install
    popd
done

find %buildroot/%_K4datadir/bin -type f | \
%ifdef _kde_alternate_placement
while read f; do mv $f %buildroot/%_kde4_bindir/; done
%else
while read f; do mv $f %buildroot/%_K4bindir/; done
%endif

install -d -m 0755 %buildroot%_sysconfdir/rc.d/init.d

mkdir -p %buildroot/etc/control.d/facilities/
cat >%buildroot/etc/control.d/facilities/kppp-kde4 <<__EOF__
#!/bin/sh
. /etc/control.d/functions
%ifdef _kde_alternate_placement
BINARY=%_kde4_bindir/kppp
%else
BINARY=%_K4bindir/kppp
%endif
new_summary "KPPP dial-up tool"
new_fmode public 4711 root root
new_fmode netadmin 4710 root netadmin
new_fmode restricted 700 root root
new_help public "Any user can use KPPP"
new_help netadmin "Only \"netadmin\" group members can use KPPP"
new_help restricted "Only root can use KPPP"
control_fmode "\$BINARY" "\$*" || exit 1
__EOF__
chmod 0755 %buildroot/etc/control.d/facilities/kppp-kde4

%pre kppp
/usr/sbin/groupadd -r -f netadmin >/dev/null 2>&1
[ $1 -eq 1 ] || /usr/sbin/control-dump kppp-kde4
%post kppp
[ $1 -eq 1 ] || /usr/sbin/control-restore kppp-kde4


%files
%files common
#%dir %_K4srv/kconfiguredialog/
#%_K4snd/KDE-Im-Phone-Ring.wav

%files core
#%_K4iconsdir/oxygen/*/*/*.*
%_K4iconsdir/hicolor/*/*/*.*

%files filesharing
%_K4lib/sambausershareplugin.so
%_K4srv/sambausershareplugin.desktop

%files kdnssd
%_K4apps/remoteview/
#%_K4apps/zeroconf/
%_K4lib/kded_dnssdwatcher.so
%_K4lib/kio_zeroconf.so
%_K4srv/kded/dnssdwatcher.desktop
%_K4srv/zeroconf.protocol

%if_enabled knewsticker
%files knewsticker
%_K4lib/plasma_applet_knewsticker.so
%_K4srv/plasma-knewsticker-default.desktop
%_K4doc/*/knewsticker
%endif

%files kget
%doc kget/AUTHORS kget/TODO
%_K4bindir/kget
%_K4apps/kget/
%_K4apps/dolphinpart/kpartplugins/kget*
%_K4apps/khtml/kpartplugins/kget*
%_K4apps/kwebkitpart/kpartplugins/kget*
%_K4lib/kget_*
%_K4lib/kcm_kget_*.so
%_K4lib/krunner_kget.so
%_K4lib/plasma_engine_kget.so
%_K4lib/plasma_kget_barapplet.so
%_K4lib/plasma_kget_piechart.so
%_libdir/strigi/strigita_torrent_analyzer.so
%_K4conf_update/kget*
%_K4dbus_services/org.kde.kget.service
%_K4xdg_apps/kget.desktop
%_K4srv/plasma-engine-kget.desktop
%_K4srv/kgetbarapplet-default.desktop
%_K4srv/kgetpiechartapplet-default.desktop
%_K4srv/ServiceMenus/kget_download.desktop
%_K4cfg/kget*
%_K4srv/kget_*
%_K4srv/plasma-runner-kget.desktop
%_K4srvtyp/kget_*
%_K4doc/*/kget

%files -n libkget4
%_K4libdir/libkgetcore.so.*

%files kppp
%doc kppp/AUTHORS kppp/README
%attr(4711, root, root) %_K4bindir/kppp
%config %_sysconfdir/control.d/facilities/kppp-kde4
%_K4bindir/kppplogview
%_K4xdg_apps/Kppp.desktop
%_K4xdg_apps/kppplogview.desktop
%_K4apps/kppp
%_K4doc/*/kppp

%files -n libkrdccore4
%_K4libdir/libkrdccore.so.*

%files krdc
%_K4bindir/krdc
%_K4bindir/krdc_rfb_approver
%_K4apps/krdc/
%_K4apps/krdc_rfb_approver/
%_K4xdg_apps/krdc.desktop
%_K4cfg/krdc.kcfg
%_K4srv/krdc_*.desktop
%_K4srv/rdp.protocol
%_K4srv/vnc.protocol
%_K4srv/ServiceMenus/smb2rdc.desktop
%_K4srvtyp/krdc_plugin.desktop
%_K4doc/*/krdc
%_K4lib/kcm_krdc_rdpplugin.so
%_K4lib/kcm_krdc_vncplugin.so
%_K4lib/krdc_rdpplugin.so
%_K4lib/krdc_testplugin.so
%_K4lib/krdc_vncplugin.so
%_K4dbus_services/org.freedesktop.Telepathy.Client.krdc_*.service
%_datadir/telepathy/clients/krdc_*.client

%files -n libkrfbprivate4
%_K4libdir/libkrfbprivate.so.*

%files krfb
%doc krfb/AUTHORS krfb/NOTES krfb/README krfb/TODO
%_K4bindir/krfb
%_K4lib/krfb_framebuffer_qt.so
%_K4lib/krfb_framebuffer_x11.so
%_K4apps/krfb/
%_K4xdg_apps/krfb.desktop
%_K4srv/krfb_framebuffer_qt.desktop
%_K4srv/krfb_framebuffer_x11.desktop
%_K4srvtyp/krfb-framebuffer.desktop
%_K4dbus_services/org.freedesktop.Telepathy.Client.krfb_*.service
%_datadir/telepathy/clients/krfb_*.client
%_K4doc/*/krfb

%files devel
%_K4link/*.so
%_K4includedir/*/
%_K4dbus_interfaces/*

%changelog
